/*
 * Decompiled with CFR 0.152.
 */
package astra.messaging;

import astra.messaging.AstraMessage;
import astra.messaging.MessageService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class UDPMQService
extends MessageService {
    private int port = 2000;
    private String hostname = "230.0.0.1";
    private InetAddress address;
    private MulticastSocket socket;
    private boolean terminating = false;

    public UDPMQService() {
        System.out.println("UDPMQService created...");
    }

    @Override
    public void configure(String key, String value) {
        if (key.equals("port")) {
            this.port = Integer.parseInt(value);
        } else if (key.equals("host")) {
            this.hostname = value;
        } else {
            System.err.println("[UDPMQService] Unknown propery: " + key);
        }
    }

    @Override
    public void start() {
        try {
            this.address = InetAddress.getByName(this.hostname);
            if (this.address.isMulticastAddress()) {
                this.socket = new MulticastSocket();
                this.socket.joinGroup(this.address);
            }
            new Thread(){

                @Override
                public void run() {
                    try {
                        MulticastSocket socket = new MulticastSocket(UDPMQService.this.port);
                        socket.joinGroup(UDPMQService.this.address);
                        while (!UDPMQService.this.terminating) {
                            try {
                                byte[] buf = new byte[64000];
                                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                                socket.receive(packet);
                                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buf));
                                AstraMessage message = (AstraMessage)in.readObject();
                                UDPMQService.this.receiveMessage(message);
                                in.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                        socket.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }.start();
            System.out.println("[UDPMQService] Service Started...");
        }
        catch (UnknownHostException uhe) {
            System.err.println("[UDPMessageTransportService] Unknown host: " + this.hostname);
        }
        catch (IOException ioe) {
            System.err.println("[UDPMessageTransportService] Error occurred setting up connection for: " + this.hostname);
        }
    }

    @Override
    public boolean sendMessage(AstraMessage message) {
        try {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baout);
            out.writeObject(message);
            byte[] buf = baout.toByteArray();
            this.socket.send(new DatagramPacket(buf, buf.length, this.address, this.port));
            out.close();
            return true;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return false;
        }
    }
}

