/*
 * Decompiled with CFR 0.152.
 */
package astra.reasoner;

import astra.core.Agent;
import astra.event.BeliefEvent;
import astra.event.Event;
import astra.event.GoalEvent;
import astra.formula.Formula;
import astra.formula.Goal;
import astra.formula.Predicate;
import astra.messaging.MessageEvent;
import astra.reasoner.EventUnifier;
import astra.reasoner.FormulaUnifier;
import astra.reasoner.unifier.ANDUnifier;
import astra.reasoner.unifier.AcreFormulaUnifier;
import astra.reasoner.unifier.BeliefEventUnifier;
import astra.reasoner.unifier.FormulaVariableUnifier;
import astra.reasoner.unifier.GoalEventUnifier;
import astra.reasoner.unifier.MessageEventUnifier;
import astra.reasoner.unifier.PredicateUnifier;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.term.Funct;
import astra.term.ListSplitter;
import astra.term.ListTerm;
import astra.term.ModuleTerm;
import astra.term.Primitive;
import astra.term.Term;
import astra.term.Variable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Unifier {
    public static Map<Class<?>, EventUnifier<?>> eventFactory = new HashMap();
    public static List<FormulaUnifier> formulaUnifiers = new LinkedList<FormulaUnifier>();

    public static Map<Integer, Term> unify(Event source, Event target, Agent agent) {
        EventUnifier<?> unifier = eventFactory.get(source.getClass());
        return unifier != null ? unifier.unify(source, target, agent) : null;
    }

    public static Map<Integer, Term> unify(Predicate source, Predicate target, Agent agent) {
        return Unifier.unify(source, target, new HashMap<Integer, Term>(), agent);
    }

    public static Map<Integer, Term> unify(Goal source, Goal target, Agent agent) {
        return Unifier.unify(source.formula(), target.formula(), agent);
    }

    public static Map<Integer, Term> unify(Term[] source, Term[] target, Map<Integer, Term> bindings, Agent agent) {
        BindingsEvaluateVisitor visitor = new BindingsEvaluateVisitor(bindings, agent);
        for (int i = 0; i < source.length; ++i) {
            ListTerm tail;
            ListTerm list;
            Term term;
            Variable var;
            Primitive<Object> sourceTerm = source[i];
            Primitive<Object> targetTerm = target[i];
            if (sourceTerm instanceof ModuleTerm) {
                sourceTerm = Primitive.newPrimitive(((ModuleTerm)((Object)sourceTerm)).evaluate(visitor));
            }
            if (targetTerm instanceof ModuleTerm) {
                targetTerm = Primitive.newPrimitive(((ModuleTerm)((Object)targetTerm)).evaluate(visitor));
            }
            if (Variable.class.isInstance(sourceTerm)) {
                var = (Variable)((Object)sourceTerm);
                term = bindings.get(var.id());
                if (term == null) {
                    bindings.put(var.id(), targetTerm);
                    continue;
                }
                if (term.equals(targetTerm)) continue;
                return null;
            }
            if (Variable.class.isInstance(targetTerm)) {
                var = (Variable)((Object)targetTerm);
                term = bindings.get(var.id());
                if (term == null) {
                    bindings.put(var.id(), sourceTerm);
                    continue;
                }
                if (term.equals(sourceTerm)) continue;
                return null;
            }
            if (ListTerm.class.isInstance(sourceTerm)) {
                if (ListTerm.class.isInstance(targetTerm)) {
                    if (((ListTerm)((Object)sourceTerm)).size() != ((ListTerm)((Object)targetTerm)).size()) {
                        return null;
                    }
                    if (Unifier.unify(((ListTerm)((Object)sourceTerm)).terms(), ((ListTerm)((Object)targetTerm)).terms(), bindings, agent) != null) continue;
                    return null;
                }
                if (ListSplitter.class.isInstance(targetTerm)) {
                    list = (ListTerm)((Object)sourceTerm);
                    if (list.size() < 1) {
                        return null;
                    }
                    tail = new ListTerm(list.subList(1, list.size()).toArray(new Term[list.size() - 1]));
                    if (Unifier.unify(new Term[]{((ListTerm)((Object)sourceTerm)).get(0), tail}, new Term[]{((ListSplitter)((Object)targetTerm)).head(), ((ListSplitter)((Object)targetTerm)).tail()}, bindings, agent) != null) continue;
                    return null;
                }
                return null;
            }
            if (ListTerm.class.isInstance(targetTerm)) {
                if (ListSplitter.class.isInstance(sourceTerm)) {
                    list = (ListTerm)((Object)targetTerm);
                    if (list.size() < 1) {
                        return null;
                    }
                    tail = new ListTerm(list.subList(1, list.size()).toArray(new Term[list.size() - 1]));
                    if (Unifier.unify(new Term[]{((ListTerm)((Object)targetTerm)).get(0), tail}, new Term[]{((ListSplitter)((Object)sourceTerm)).head(), ((ListSplitter)((Object)sourceTerm)).tail()}, bindings, agent) != null) continue;
                    return null;
                }
                return null;
            }
            if (Funct.class.isInstance(sourceTerm)) {
                if (!Funct.class.isInstance(targetTerm)) {
                    throw new RuntimeException("Could not match: " + sourceTerm + " to: " + targetTerm + "\nTarget is not a funct, but is: " + target.getClass().getCanonicalName());
                }
                Funct sf = (Funct)((Object)sourceTerm);
                Funct tf = (Funct)((Object)targetTerm);
                if (sf.id() != tf.id() || sf.size() != tf.size()) {
                    return null;
                }
                if (Unifier.unify(((Funct)((Object)sourceTerm)).terms(), ((Funct)((Object)targetTerm)).terms(), bindings, agent) != null) continue;
                return null;
            }
            if (((Object)sourceTerm).equals(targetTerm)) continue;
            return null;
        }
        return bindings;
    }

    public static Map<Integer, Term> unify(Formula source, Formula target, Map<Integer, Term> bindings, Agent agent) {
        for (FormulaUnifier unifier : formulaUnifiers) {
            if (!unifier.isApplicable(source, target)) continue;
            return unifier.unify(source, target, bindings, agent);
        }
        return null;
    }

    static {
        eventFactory.put(BeliefEvent.class, new BeliefEventUnifier());
        eventFactory.put(GoalEvent.class, new GoalEventUnifier());
        eventFactory.put(MessageEvent.class, new MessageEventUnifier());
        formulaUnifiers.add(new FormulaVariableUnifier());
        formulaUnifiers.add(new PredicateUnifier());
        formulaUnifiers.add(new AcreFormulaUnifier());
        formulaUnifiers.add(new ANDUnifier());
    }
}

