/*
 * Decompiled with CFR 0.152.
 */
package astra.reasoner.node;

import astra.formula.OR;
import astra.reasoner.NewReasoner;
import astra.reasoner.Reasoner;
import astra.reasoner.node.ReasonerNode;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.term.Term;
import java.util.Map;
import java.util.Stack;

public class ORReasonerNode
extends ReasonerNode {
    ReasonerNode left;
    ReasonerNode right;
    OR or;
    int state = 0;

    public ORReasonerNode(ReasonerNode parent, OR or, Map<Integer, Term> initial, boolean singleResult) {
        super(parent, singleResult);
        this.or = or;
        this.initial = initial;
    }

    @Override
    public ReasonerNode initialize(Reasoner reasoner) {
        this.visitor = new BindingsEvaluateVisitor(this.initial, reasoner.agent());
        this.or = (OR)this.or.accept(this.visitor);
        return super.initialize(reasoner);
    }

    @Override
    public boolean solve(Reasoner reasoner, Stack<ReasonerNode> stack) {
        switch (this.state) {
            case 0: {
                this.left = ((NewReasoner)reasoner).createReasonerNode(this, this.or.left(), this.initial, true);
                this.left.singleResult = false;
                ++this.state;
            }
            case 1: {
                stack.push(this.left);
                ++this.state;
                return true;
            }
            case 2: {
                if (!this.left.isFailed()) {
                    if (this.singleResult) {
                        this.solutions.add(this.left.solutions.isEmpty() ? this.initial : this.left.solutions.get(0));
                    } else {
                        this.solutions = this.left.solutions;
                    }
                    this.finished = true;
                    return true;
                }
                this.right = ((NewReasoner)reasoner).createReasonerNode(this, this.or.right(), this.initial, true);
                this.right.singleResult = false;
                ++this.state;
            }
            case 3: {
                stack.push(this.right);
                ++this.state;
                return true;
            }
            case 4: {
                if (this.right.isFailed()) {
                    this.finished = true;
                    this.failed = true;
                    return false;
                }
                if (this.singleResult) {
                    this.solutions.add(this.right.solutions.isEmpty() ? this.initial : this.right.solutions.get(0));
                } else {
                    this.solutions = this.right.solutions;
                }
                this.finished = true;
                return true;
            }
        }
        return false;
    }
}

