/*
 * Decompiled with CFR 0.152.
 */
package astra.reasoner.node;

import astra.formula.Formula;
import astra.formula.Inference;
import astra.formula.Predicate;
import astra.reasoner.BeliefIterator;
import astra.reasoner.NewReasoner;
import astra.reasoner.Reasoner;
import astra.reasoner.Unifier;
import astra.reasoner.node.ReasonerNode;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.reasoner.util.RenameVisitor;
import astra.reasoner.util.Utilities;
import astra.reasoner.util.VariableVisitor;
import astra.term.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class PredicateReasonerNode
extends ReasonerNode {
    Predicate predicate;
    List<Formula> options = new ArrayList<Formula>();
    BeliefIterator beliefIterator;
    int index = 0;
    static int counter = 0;
    int state = 0;
    ReasonerNode node;
    VariableVisitor variableVisitor;
    Map<Integer, Term> bindings;
    int successes = 0;

    public PredicateReasonerNode(ReasonerNode parent, Predicate predicate, Map<Integer, Term> initial, boolean singleResult) {
        super(parent, singleResult);
        this.predicate = predicate;
        this.initial = initial;
    }

    @Override
    public ReasonerNode initialize(Reasoner reasoner) {
        this.visitor = new BindingsEvaluateVisitor(this.initial, reasoner.agent());
        this.predicate = (Predicate)this.predicate.accept(this.visitor);
        this.beliefIterator = new BeliefIterator(reasoner.sources(), this.predicate);
        return super.initialize(reasoner);
    }

    @Override
    public boolean solve(Reasoner reasoner, Stack<ReasonerNode> stack) {
        if (this.predicate.equals(Predicate.FALSE)) {
            this.finished = true;
            this.failed = true;
            return false;
        }
        if (this.predicate.equals(Predicate.TRUE)) {
            this.solutions.add(this.initial);
            this.finished = true;
            return true;
        }
        switch (this.state) {
            case 0: {
                if (!this.beliefIterator.hasNext()) {
                    this.finished = true;
                    if (this.successes == 0) {
                        this.failed = true;
                        return false;
                    }
                    return true;
                }
                Formula formula = this.beliefIterator.next();
                if (Predicate.class.isInstance(formula)) {
                    Map<Integer, Term> bindings = Unifier.unify(this.predicate, (Predicate)formula.accept(this.visitor), new HashMap<Integer, Term>(this.initial), reasoner.agent());
                    if (bindings == null) {
                        return true;
                    }
                    ++this.successes;
                    this.solutions.add(bindings);
                    if (this.singleResult) {
                        this.finished = true;
                    }
                    return true;
                }
                if (!Inference.class.isInstance(formula)) break;
                Inference inference = (Inference)formula;
                RenameVisitor renameVisitor = new RenameVisitor("rn_" + counter++ + "_");
                inference = (Inference)inference.accept(renameVisitor);
                this.bindings = Unifier.unify(this.predicate, inference.head(), new HashMap<Integer, Term>(this.initial), reasoner.agent());
                if (this.bindings == null) {
                    return true;
                }
                this.variableVisitor = new VariableVisitor();
                this.predicate.accept(this.variableVisitor);
                Formula target = (Formula)inference.body().accept(new BindingsEvaluateVisitor(this.bindings, reasoner.agent()));
                this.node = ((NewReasoner)reasoner).createReasonerNode(this, target, this.initial, true);
                stack.add(this.node);
                this.state = 1;
                return true;
            }
            case 1: {
                if (this.node.isFailed()) {
                    this.state = 0;
                    return true;
                }
                ++this.successes;
                for (Map<Integer, Term> b : this.node.solutions) {
                    this.solutions.add(Utilities.merge(this.initial, Utilities.filter(Utilities.mgu(Utilities.merge(this.bindings, b)), this.variableVisitor.variables())));
                    if (!this.singleResult) continue;
                    this.finished = true;
                    return true;
                }
                this.state = 0;
                return true;
            }
        }
        return true;
    }

    public String toString() {
        return this.predicate.toString();
    }
}

