/*
 * Decompiled with CFR 0.152.
 */
package astra.reasoner.node;

import astra.reasoner.Reasoner;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.term.Term;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public abstract class ReasonerNode {
    public static final int MAX_DEPTH = 50;
    protected ReasonerNode parent;
    protected List<ReasonerNode> children = new ArrayList<ReasonerNode>();
    protected List<Map<Integer, Term>> solutions = new LinkedList<Map<Integer, Term>>();
    protected boolean singleResult = false;
    protected int depth;
    protected boolean finished = false;
    protected boolean failed = false;
    protected Map<Integer, Term> initial;
    protected BindingsEvaluateVisitor visitor;

    public ReasonerNode(ReasonerNode parent, boolean singleResult) {
        this.parent = parent;
        this.singleResult = singleResult;
        this.depth = parent == null ? 0 : parent.depth + 1;
    }

    public ReasonerNode initialize(Reasoner reasoner) {
        return this;
    }

    public abstract boolean solve(Reasoner var1, Stack<ReasonerNode> var2);

    public boolean failed(Reasoner reasoner, Stack<ReasonerNode> stack) {
        if (this.parent != null) {
            stack.pop();
            return true;
        }
        return false;
    }

    public boolean resolve(Reasoner reasoner, Stack<ReasonerNode> stack) {
        if (this.isMaxDepth()) {
            this.finished = true;
            this.failed = true;
            return false;
        }
        return this.solve(reasoner, stack);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isMaxDepth() {
        return this.depth == 50;
    }

    public boolean isSingleResult() {
        return this.singleResult;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public List<Map<Integer, Term>> solutions() {
        return this.solutions;
    }
}

