/*
 * Decompiled with CFR 0.152.
 */
package astra.reasoner.util;

import astra.formula.AND;
import astra.formula.Bind;
import astra.formula.BracketFormula;
import astra.formula.Comparison;
import astra.formula.Formula;
import astra.formula.FormulaVariable;
import astra.formula.Goal;
import astra.formula.ModuleFormula;
import astra.formula.NOT;
import astra.formula.OR;
import astra.formula.Predicate;
import astra.reasoner.util.LogicVisitor;
import astra.term.AtIndex;
import astra.term.Brackets;
import astra.term.Count;
import astra.term.FormulaTerm;
import astra.term.Funct;
import astra.term.Head;
import astra.term.ListSplitter;
import astra.term.ListTerm;
import astra.term.Operator;
import astra.term.Performative;
import astra.term.Primitive;
import astra.term.Tail;
import astra.term.Term;
import astra.term.Variable;
import astra.type.Type;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractEvaluateVisitor
implements LogicVisitor {
    private static Map<Class<? extends Formula>, Handler<? extends Formula>> formulaHandlers = new HashMap<Class<? extends Formula>, Handler<? extends Formula>>();
    private static Map<Class<? extends Term>, Handler<? extends Term>> termHandlers = new HashMap<Class<? extends Term>, Handler<? extends Term>>();
    protected boolean passByValue = true;

    public static <T extends Formula> void addFormulaHandler(Handler<T> handler) {
        formulaHandlers.put(handler.getType(), handler);
    }

    public static <T extends Term> void addTermHandler(Handler<T> handler) {
        termHandlers.put(handler.getType(), handler);
    }

    private static <T extends Formula> Handler<Formula> getFormulaHandler(Class<T> cls) {
        return formulaHandlers.get(cls);
    }

    private static <T extends Term> Handler<Term> getTermHandler(Class<T> cls) {
        return termHandlers.get(cls);
    }

    public AbstractEvaluateVisitor(boolean passByValue) {
        this.passByValue = passByValue;
    }

    @Override
    public Object visit(Formula formula) {
        Handler<Formula> handler = AbstractEvaluateVisitor.getFormulaHandler(formula.getClass());
        if (handler == null) {
            return null;
        }
        return handler.handle(this, formula, this.passByValue);
    }

    @Override
    public Object visit(Term term) {
        Handler<Term> handler = AbstractEvaluateVisitor.getTermHandler(term.getClass());
        if (handler == null) {
            return null;
        }
        return handler.handle(this, term, this.passByValue);
    }

    static {
        AbstractEvaluateVisitor.addFormulaHandler(new Handler<Predicate>(){

            @Override
            public Class<Predicate> getType() {
                return Predicate.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Predicate predicate, boolean passByValue) {
                Term[] terms = new Term[predicate.size()];
                for (int i = 0; i < predicate.size(); ++i) {
                    terms[i] = (Term)predicate.getTerm(i).accept(visitor);
                }
                return new Predicate(predicate.predicate(), terms);
            }
        });
        AbstractEvaluateVisitor.addFormulaHandler(new Handler<ModuleFormula>(){

            @Override
            public Class<ModuleFormula> getType() {
                return ModuleFormula.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, ModuleFormula formula, boolean passByValue) {
                return new ModuleFormula(formula.module(), (Predicate)formula.predicate().accept(visitor), formula.adaptor());
            }
        });
        AbstractEvaluateVisitor.addFormulaHandler(new Handler<AND>(){

            @Override
            public Class<AND> getType() {
                return AND.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, AND and, boolean passByValue) {
                return new AND((Formula)and.left().accept(visitor), (Formula)and.right().accept(visitor));
            }
        });
        AbstractEvaluateVisitor.addFormulaHandler(new Handler<OR>(){

            @Override
            public Class<OR> getType() {
                return OR.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, OR or, boolean passByValue) {
                return new OR((Formula)or.left().accept(visitor), (Formula)or.right().accept(visitor));
            }
        });
        AbstractEvaluateVisitor.addFormulaHandler(new Handler<NOT>(){

            @Override
            public Class<NOT> getType() {
                return NOT.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, NOT not, boolean passByValue) {
                return new NOT((Formula)not.formula().accept(visitor));
            }
        });
        AbstractEvaluateVisitor.addFormulaHandler(new Handler<Goal>(){

            @Override
            public Class<Goal> getType() {
                return Goal.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Goal goal, boolean passByValue) {
                return new Goal((Predicate)goal.formula().accept(visitor));
            }
        });
        AbstractEvaluateVisitor.addFormulaHandler(new Handler<FormulaVariable>(){

            @Override
            public Class<FormulaVariable> getType() {
                return FormulaVariable.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, FormulaVariable variable, boolean passByValue) {
                return variable.variable().accept(visitor);
            }
        });
        AbstractEvaluateVisitor.addFormulaHandler(new Handler<BracketFormula>(){

            @Override
            public Class<BracketFormula> getType() {
                return BracketFormula.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, BracketFormula formula, boolean passByValue) {
                return new BracketFormula((Formula)formula.formula().accept(visitor));
            }
        });
        AbstractEvaluateVisitor.addFormulaHandler(new Handler<Bind>(){

            @Override
            public Class<Bind> getType() {
                return Bind.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Bind bind, boolean passByValue) {
                Bind b = new Bind(bind.variable(), (Term)bind.term().accept(visitor));
                return b;
            }
        });
        AbstractEvaluateVisitor.addFormulaHandler(new Handler<Comparison>(){

            @Override
            public Class<Comparison> getType() {
                return Comparison.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Comparison comparison, boolean passByValue) {
                Term il = (Term)comparison.left().accept(visitor);
                Term ir = (Term)comparison.right().accept(visitor);
                if (il instanceof Variable || ir instanceof Variable) {
                    return new Comparison(comparison.operator(), il, ir);
                }
                if (Type.isNumeric(il) && Type.isNumeric(ir)) {
                    Primitive l = (Primitive)il;
                    Primitive r = (Primitive)ir;
                    if (comparison.operator() == "<") {
                        return Type.doubleValue(l) < Type.doubleValue(r) ? Predicate.TRUE : Predicate.FALSE;
                    }
                    if (comparison.operator() == "<=") {
                        return Type.doubleValue(l) <= Type.doubleValue(r) ? Predicate.TRUE : Predicate.FALSE;
                    }
                    if (comparison.operator() == ">") {
                        return Type.doubleValue(l) > Type.doubleValue(r) ? Predicate.TRUE : Predicate.FALSE;
                    }
                    if (comparison.operator() == ">=") {
                        return Type.doubleValue(l) >= Type.doubleValue(r) ? Predicate.TRUE : Predicate.FALSE;
                    }
                    if (comparison.operator() == "==") {
                        return Type.doubleValue(l) == Type.doubleValue(r) ? Predicate.TRUE : Predicate.FALSE;
                    }
                    if (comparison.operator() == "~=" || comparison.operator() == "!=") {
                        return Type.doubleValue(l) != Type.doubleValue(r) ? Predicate.TRUE : Predicate.FALSE;
                    }
                } else if (il.type() == Type.STRING && ir.type() == Type.STRING) {
                    Primitive l = (Primitive)il;
                    Primitive r = (Primitive)ir;
                    if (comparison.operator() == "==") {
                        return l.equals(r) ? Predicate.TRUE : Predicate.FALSE;
                    }
                    if (comparison.operator() == "~=") {
                        return l.equals(r) ? Predicate.FALSE : Predicate.TRUE;
                    }
                    System.out.println("unknown opeator: " + comparison.operator());
                } else if (il.type() == Type.BOOLEAN && ir.type() == Type.BOOLEAN) {
                    Primitive l = (Primitive)il;
                    Primitive r = (Primitive)ir;
                    if (comparison.operator() == "==") {
                        return l.equals(r) ? Predicate.TRUE : Predicate.FALSE;
                    }
                    if (comparison.operator() == "~=") {
                        return l.equals(r) ? Predicate.FALSE : Predicate.TRUE;
                    }
                } else if (il.type() == Type.LIST && ir.type() == Type.LIST) {
                    ListTerm l = (ListTerm)il;
                    ListTerm r = (ListTerm)ir;
                    if (comparison.operator() == "==") {
                        return l.equals(r) ? Predicate.TRUE : Predicate.FALSE;
                    }
                    if (comparison.operator() == "~=") {
                        return l.equals(r) ? Predicate.FALSE : Predicate.TRUE;
                    }
                } else {
                    System.out.println("Comparison Not Supported: " + comparison);
                    System.out.println("Left Type: " + il.type());
                    System.out.println("Right Type: " + ir.type());
                }
                throw new RuntimeException("Problem comparing non-numeric terms in astra.plan.EvaluateVisitor: " + comparison);
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<Primitive>(){

            @Override
            public Class<Primitive> getType() {
                return Primitive.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Primitive term, boolean passByValue) {
                return term;
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<Funct>(){

            @Override
            public Class<Funct> getType() {
                return Funct.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Funct function, boolean passByValue) {
                Term[] terms = new Term[function.size()];
                for (int i = 0; i < function.size(); ++i) {
                    terms[i] = (Term)function.getTerm(i).accept(visitor);
                }
                return new Funct(function.functor(), terms);
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<ListTerm>(){

            @Override
            public Class<ListTerm> getType() {
                return ListTerm.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, ListTerm list, boolean passByValue) {
                if (passByValue) {
                    ListTerm out = new ListTerm();
                    for (int i = 0; i < list.size(); ++i) {
                        out.add((Term)list.get(i).accept(visitor));
                    }
                    return out;
                }
                for (int i = 0; i < list.size(); ++i) {
                    list.set(i, (Term)list.get(i).accept(visitor));
                }
                return list;
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<Operator>(){

            @Override
            public Class<Operator> getType() {
                return Operator.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Operator operator, boolean passByValue) {
                ((AbstractEvaluateVisitor)visitor).passByValue = true;
                Term l = (Term)operator.left().accept(visitor);
                Term r = (Term)operator.right().accept(visitor);
                ((AbstractEvaluateVisitor)visitor).passByValue = passByValue;
                if (l instanceof Variable || r instanceof Variable) {
                    return Operator.newOperator(operator.op(), l, r);
                }
                if (operator.type().equals(Type.STRING)) {
                    try {
                        if (operator.op() == '+') {
                            return Primitive.newPrimitive(Type.stringValue(l) + Type.stringValue(r));
                        }
                    }
                    catch (Throwable th) {
                        System.out.println("Failed to evaluate: " + operator);
                        System.out.println("Left: " + Type.stringValue(l));
                        System.out.println("Right: " + Type.stringValue(r));
                        th.printStackTrace();
                        System.exit(0);
                    }
                } else if (operator.type().equals(Type.LIST)) {
                    if (operator.op() == '+') {
                        return ((ListTerm)l).merge((ListTerm)r);
                    }
                } else if (operator.type().equals(Type.INTEGER)) {
                    if (operator.op() == '+') {
                        return Primitive.newPrimitive(Type.integerValue(l) + Type.integerValue(r));
                    }
                    if (operator.op() == '-') {
                        return Primitive.newPrimitive(Type.integerValue(l) - Type.integerValue(r));
                    }
                    if (operator.op() == '*') {
                        return Primitive.newPrimitive(Type.integerValue(l) * Type.integerValue(r));
                    }
                    if (operator.op() == '/') {
                        return Primitive.newPrimitive(Type.integerValue(l) / Type.integerValue(r));
                    }
                    if (operator.op() == '%') {
                        return Primitive.newPrimitive(Type.integerValue(l) % Type.integerValue(r));
                    }
                } else if (operator.type().equals(Type.LONG)) {
                    if (operator.op() == '+') {
                        return Primitive.newPrimitive(Type.longValue(l) + Type.longValue(r));
                    }
                    if (operator.op() == '-') {
                        return Primitive.newPrimitive(Type.longValue(l) - Type.longValue(r));
                    }
                    if (operator.op() == '*') {
                        return Primitive.newPrimitive(Type.longValue(l) * Type.longValue(r));
                    }
                    if (operator.op() == '/') {
                        return Primitive.newPrimitive(Type.longValue(l) / Type.longValue(r));
                    }
                    if (operator.op() == '%') {
                        return Primitive.newPrimitive(Type.longValue(l) % Type.longValue(r));
                    }
                } else if (operator.type().equals(Type.FLOAT)) {
                    if (operator.op() == '+') {
                        return Primitive.newPrimitive(Float.valueOf(Type.floatValue(l) + Type.floatValue(r)));
                    }
                    if (operator.op() == '-') {
                        return Primitive.newPrimitive(Float.valueOf(Type.floatValue(l) - Type.floatValue(r)));
                    }
                    if (operator.op() == '*') {
                        return Primitive.newPrimitive(Float.valueOf(Type.floatValue(l) * Type.floatValue(r)));
                    }
                    if (operator.op() == '/') {
                        return Primitive.newPrimitive(Float.valueOf(Type.floatValue(l) / Type.floatValue(r)));
                    }
                } else if (operator.type().equals(Type.DOUBLE)) {
                    if (operator.op() == '+') {
                        return Primitive.newPrimitive(Type.doubleValue(l) + Type.doubleValue(r));
                    }
                    if (operator.op() == '-') {
                        return Primitive.newPrimitive(Type.doubleValue(l) - Type.doubleValue(r));
                    }
                    if (operator.op() == '*') {
                        return Primitive.newPrimitive(Type.doubleValue(l) * Type.doubleValue(r));
                    }
                    if (operator.op() == '/') {
                        return Primitive.newPrimitive(Type.doubleValue(l) / Type.doubleValue(r));
                    }
                }
                return null;
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<Performative>(){

            @Override
            public Class<Performative> getType() {
                return Performative.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Performative performative, boolean passByValue) {
                return performative;
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<FormulaTerm>(){

            @Override
            public Class<FormulaTerm> getType() {
                return FormulaTerm.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, FormulaTerm formula, boolean passByValue) {
                if (formula.value() != null) {
                    formula.value().accept(visitor);
                }
                return null;
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<Brackets>(){

            @Override
            public Class<Brackets> getType() {
                return Brackets.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Brackets term, boolean passByValue) {
                return term.term().accept(visitor);
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<ListSplitter>(){

            @Override
            public Class<ListSplitter> getType() {
                return ListSplitter.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, ListSplitter term, boolean passByValue) {
                return term;
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<Count>(){

            @Override
            public Class<Count> getType() {
                return Count.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Count count, boolean passByValue) {
                Term c = (Term)count.term().accept(visitor);
                if (c instanceof ListTerm) {
                    return Primitive.newPrimitive(((ListTerm)c).size());
                }
                return count;
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<Head>(){

            @Override
            public Class<Head> getType() {
                return Head.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Head head, boolean passByValue) {
                Term c = (Term)head.term().accept(visitor);
                if (c instanceof ListTerm) {
                    return ((ListTerm)c).get(0);
                }
                return head;
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<Tail>(){

            @Override
            public Class<Tail> getType() {
                return Tail.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Tail tail, boolean passByValue) {
                Term c = (Term)tail.term().accept(visitor);
                if (c instanceof ListTerm) {
                    ListTerm tailList = new ListTerm();
                    for (int i = 1; i < ((ListTerm)c).size(); ++i) {
                        tailList.add(((ListTerm)c).get(i));
                    }
                    return tailList;
                }
                return tail;
            }
        });
        AbstractEvaluateVisitor.addTermHandler(new Handler<AtIndex>(){

            @Override
            public Class<AtIndex> getType() {
                return AtIndex.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, AtIndex atIndex, boolean passByValue) {
                Term t = (Term)atIndex.term().accept(visitor);
                Term i = (Term)atIndex.index().accept(visitor);
                if (t instanceof ListTerm && i instanceof Primitive) {
                    return ((ListTerm)t).get((Integer)((Primitive)i).value());
                }
                return atIndex;
            }
        });
    }

    public static interface Handler<T> {
        public Class<T> getType();

        public Object handle(LogicVisitor var1, T var2, boolean var3);
    }
}

