/*
 * Decompiled with CFR 0.152.
 */
package astra.reasoner.util;

import astra.core.Agent;
import astra.formula.Formula;
import astra.formula.FormulaVariable;
import astra.formula.Inference;
import astra.formula.IsNull;
import astra.formula.Predicate;
import astra.reasoner.util.AbstractEvaluateVisitor;
import astra.reasoner.util.LogicVisitor;
import astra.term.FormulaTerm;
import astra.term.Funct;
import astra.term.ListTerm;
import astra.term.ModuleTerm;
import astra.term.NullTerm;
import astra.term.Operator;
import astra.term.Primitive;
import astra.term.QueryTerm;
import astra.term.Term;
import astra.term.Variable;
import astra.type.Type;
import java.util.HashMap;
import java.util.Map;

public class BindingsEvaluateVisitor
extends AbstractEvaluateVisitor {
    private static Map<Class<? extends Formula>, Handler<? extends Formula>> formulaHandlers = new HashMap<Class<? extends Formula>, Handler<? extends Formula>>();
    private static Map<Class<? extends Term>, Handler<? extends Term>> termHandlers = new HashMap<Class<? extends Term>, Handler<? extends Term>>();
    Map<Integer, Term> bindings;
    Agent agent;

    public static <T extends Formula> void addFormulaHandler(Handler<T> handler) {
        formulaHandlers.put(handler.getType(), handler);
    }

    public static <T extends Term> void addTermHandler(Handler<T> handler) {
        termHandlers.put(handler.getType(), handler);
    }

    private static <T extends Formula> Handler<Formula> getFormulaHandler(Class<T> cls) {
        return formulaHandlers.get(cls);
    }

    private static <T extends Term> Handler<Term> getTermHandler(Class<T> cls) {
        return termHandlers.get(cls);
    }

    public BindingsEvaluateVisitor(Map<Integer, Term> bindings, Agent agent) {
        super(false);
        this.bindings = bindings;
        this.agent = agent;
    }

    public Agent agent() {
        return this.agent;
    }

    @Override
    public Object visit(Formula formula) {
        Handler<Formula> handler = BindingsEvaluateVisitor.getFormulaHandler(formula.getClass());
        if (handler == null) {
            return super.visit(formula);
        }
        return handler.handle(this, formula, this.bindings, this.agent);
    }

    @Override
    public Object visit(Term term) {
        Handler<Term> handler = BindingsEvaluateVisitor.getTermHandler(term.getClass());
        if (handler == null) {
            return super.visit(term);
        }
        return handler.handle(this, term, this.bindings, this.agent);
    }

    public <T> T evaluate(Term term) {
        if (term instanceof Primitive) {
            Object val = ((Primitive)term).value();
            return val;
        }
        if (term instanceof Variable) {
            Term t = (Term)term.accept(this);
            if (t instanceof Variable) {
                return null;
            }
            return this.evaluate(t);
        }
        if (term instanceof Operator) {
            return ((Primitive)term.accept(this)).value();
        }
        if (term instanceof ModuleTerm) {
            return ((Primitive)term.accept(this)).value();
        }
        if (term instanceof ListTerm || term instanceof FormulaTerm || term instanceof Funct) {
            return (T)term.accept(this);
        }
        if (term instanceof ModuleTerm) {
            return ((Primitive)term.accept(this)).value();
        }
        if (term instanceof NullTerm) {
            return null;
        }
        System.out.println("[ModuleFormulaAdaptor] FAILED TO EVALUATE: " + term.getClass().getName());
        return null;
    }

    static {
        BindingsEvaluateVisitor.addTermHandler(new Handler<Variable>(){

            @Override
            public Class<Variable> getType() {
                return Variable.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Variable variable, Map<Integer, Term> bindings, Agent agent) {
                Term term = bindings.get(variable.id());
                if (term == null) {
                    return variable;
                }
                return term;
            }
        });
        BindingsEvaluateVisitor.addTermHandler(new Handler<ModuleTerm>(){

            @Override
            public Class<ModuleTerm> getType() {
                return ModuleTerm.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, ModuleTerm term, Map<Integer, Term> bindings, Agent agent) {
                Object value = term.evaluate((BindingsEvaluateVisitor)visitor);
                if (value == null) {
                    return new NullTerm();
                }
                if (Type.getType(value).equals(Type.LIST) || Type.getType(value).equals(Type.FORMULA) || Type.getType(value).equals(Type.FUNCTION)) {
                    return value;
                }
                return Primitive.newPrimitive(value);
            }
        });
        BindingsEvaluateVisitor.addTermHandler(new Handler<QueryTerm>(){

            @Override
            public Class<QueryTerm> getType() {
                return QueryTerm.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, QueryTerm term, Map<Integer, Term> bindings, Agent agent) {
                return Primitive.newPrimitive(agent.query(term.formula(), bindings) != null);
            }
        });
        BindingsEvaluateVisitor.addFormulaHandler(new Handler<IsNull>(){

            @Override
            public Class<IsNull> getType() {
                return IsNull.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, IsNull isNull, Map<Integer, Term> bindings, Agent agent) {
                Term t = isNull.formula();
                if (t instanceof Variable) {
                    Term term = bindings.get(((Variable)t).id());
                    return term == null ? Predicate.TRUE : Predicate.FALSE;
                }
                if (t instanceof FormulaVariable) {
                    Term term = bindings.get(((FormulaVariable)((Object)t)).variable().id());
                    return term == null ? Predicate.TRUE : Predicate.FALSE;
                }
                return Predicate.FALSE;
            }
        });
        BindingsEvaluateVisitor.addFormulaHandler(new Handler<Inference>(){

            @Override
            public Class<Inference> getType() {
                return Inference.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Inference inference, Map<Integer, Term> bindings, Agent agent) {
                return new Inference((Predicate)inference.head().accept(visitor), (Formula)inference.body().accept(visitor));
            }
        });
    }

    public static interface Handler<T> {
        public Class<T> getType();

        public Object handle(LogicVisitor var1, T var2, Map<Integer, Term> var3, Agent var4);
    }
}

