/*
 * Decompiled with CFR 0.152.
 */
package astra.reasoner.util;

import astra.formula.Formula;
import astra.formula.Predicate;
import astra.term.Funct;
import astra.term.ListTerm;
import astra.term.Primitive;
import astra.term.Term;
import astra.type.ObjectType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ContentCodec {
    private static ContentCodec codec;
    private ObjectMapper mapper = new ObjectMapper();

    public static ContentCodec getInstance() {
        if (codec == null) {
            codec = new ContentCodec();
        }
        return codec;
    }

    public String encode(Formula formula) {
        if (formula instanceof Predicate) {
            return this.encode((Predicate)formula);
        }
        System.out.println("Unexpected format: " + formula.getClass().getCanonicalName());
        return null;
    }

    private String encode(Predicate predicate) {
        ArrayNode terms = this.mapper.createArrayNode();
        for (Term term : predicate.terms()) {
            terms.add((JsonNode)this.encode(term));
        }
        ObjectNode node = this.mapper.createObjectNode();
        node.put("predicate", predicate.predicate());
        node.set("terms", (JsonNode)terms);
        try {
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ObjectNode encode(Term term) {
        if (term instanceof Primitive) {
            return this.encode((Primitive)term);
        }
        if (term instanceof ListTerm) {
            return this.encode((ListTerm)term);
        }
        if (term instanceof Funct) {
            return this.encode((Funct)term);
        }
        throw new RuntimeException("Could not encode: " + term);
    }

    private ObjectNode encode(Primitive<?> primitive) {
        ObjectNode node = this.mapper.createObjectNode();
        if (primitive.type() instanceof ObjectType) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(bout);
                out.writeObject(primitive.value());
                node.put("type", "object");
                node.put("value", bout.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        } else {
            node.put("type", primitive.type().toString());
            node.putPOJO("value", primitive.value());
        }
        return node;
    }

    private ObjectNode encode(ListTerm list) {
        ArrayNode array = this.mapper.createArrayNode();
        for (Term term : list) {
            array.add((JsonNode)this.encode(term));
        }
        ObjectNode node = this.mapper.createObjectNode();
        node.put("type", "list");
        node.set("value", (JsonNode)array);
        return node;
    }

    private ObjectNode encode(Funct funct) {
        ArrayNode array = this.mapper.createArrayNode();
        for (Term term : funct.terms()) {
            array.add((JsonNode)this.encode(term));
        }
        ObjectNode node = this.mapper.createObjectNode();
        node.put("type", "funct");
        node.put("functor", funct.functor());
        node.set("value", (JsonNode)array);
        return node;
    }

    public Formula decode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        try {
            return this.decode(mapper.readTree(json));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Formula decode(JsonNode node) {
        if (node instanceof ObjectNode) {
            return this.decode((ObjectNode)node);
        }
        if (node instanceof ArrayNode) {
            return this.decode((JsonNode)((ArrayNode)node));
        }
        return null;
    }

    public Formula decode(ObjectNode ObjectNode2) {
        String predicate = ObjectNode2.get("predicate").asText();
        if (predicate != null) {
            return this.decode_predicate(predicate, ObjectNode2);
        }
        return null;
    }

    private Predicate decode_predicate(String predicate, ObjectNode ObjectNode2) {
        ArrayNode array = (ArrayNode)ObjectNode2.get("terms");
        Term[] terms = new Term[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            terms[i] = this.decode_term((ObjectNode)array.get(i));
        }
        return new Predicate(predicate, terms);
    }

    private Term decode_term(ObjectNode object) {
        String type = object.get("type").asText();
        if (type.equals("string")) {
            return Primitive.newPrimitive(object.get("value").asText());
        }
        if (type.equals("integer")) {
            return Primitive.newPrimitive(object.get("value").asInt());
        }
        if (type.equals("long")) {
            return Primitive.newPrimitive(object.get("value").asLong());
        }
        if (type.equals("float")) {
            return Primitive.newPrimitive(Float.valueOf(object.get("value").floatValue()));
        }
        if (type.equals("double")) {
            return Primitive.newPrimitive(object.get("value").asDouble());
        }
        if (type.equals("char")) {
            return Primitive.newPrimitive(Character.valueOf(object.get("value").asText().charAt(0)));
        }
        if (type.equals("boolean")) {
            return Primitive.newPrimitive(object.get("value").asBoolean());
        }
        if (type.equals("list")) {
            return this.decode_list((ArrayNode)object.get("value"));
        }
        if (type.equals("funct")) {
            return this.decode_funct(object);
        }
        if (type.equals("object")) {
            return this.decode_object(object);
        }
        return null;
    }

    private Term decode_object(ObjectNode object) {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(object.get("value").binaryValue());
            ObjectInputStream in = new ObjectInputStream(bin);
            Object obj = in.readObject();
            return Primitive.newPrimitive(obj);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Term decode_funct(ObjectNode object) {
        String functor = object.get("functor").asText();
        ArrayNode array = (ArrayNode)object.get("value");
        Term[] terms = new Term[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            terms[i] = this.decode_term((ObjectNode)array.get(i));
        }
        return new Funct(functor, terms);
    }

    private Term decode_list(ArrayNode array) {
        Term[] terms = new Term[array.size()];
        for (int i = 0; i < terms.length; ++i) {
            terms[i] = this.decode_term((ObjectNode)array.get(i));
        }
        return new ListTerm(terms);
    }

    public static void main(String[] args) {
        ContentCodec.test_predicate(new Predicate("test", new Term[]{Primitive.newPrimitive("rem"), Primitive.newPrimitive("happy")}));
        ContentCodec.test_predicate(new Predicate("test", new Term[]{Primitive.newPrimitive("rem"), Primitive.newPrimitive(42)}));
        ContentCodec.test_predicate(new Predicate("test", new Term[]{Primitive.newPrimitive("rem"), Primitive.newPrimitive(42L)}));
        ContentCodec.test_predicate(new Predicate("test", new Term[]{Primitive.newPrimitive("rem"), Primitive.newPrimitive(Float.valueOf(42.0f))}));
        ContentCodec.test_predicate(new Predicate("test", new Term[]{Primitive.newPrimitive("rem"), Primitive.newPrimitive(42.5)}));
        ContentCodec.test_predicate(new Predicate("test", new Term[]{Primitive.newPrimitive("rem"), Primitive.newPrimitive(Character.valueOf('a'))}));
        ContentCodec.test_predicate(new Predicate("test", new Term[]{Primitive.newPrimitive("rem"), Primitive.newPrimitive(true)}));
        ContentCodec.test_predicate(new Predicate("test", new Term[]{Primitive.newPrimitive("rem"), new ListTerm(new Term[]{Primitive.newPrimitive(104), Primitive.newPrimitive(105)})}));
        ContentCodec.test_predicate(new Predicate("test", new Term[]{Primitive.newPrimitive("rem"), new Funct("test", new Term[]{Primitive.newPrimitive(true)})}));
        ContentCodec.test_predicate(new Predicate("test", new Term[]{Primitive.newPrimitive("rem"), Primitive.newPrimitive(new Test())}));
    }

    private static void test_predicate(Predicate p) {
        String json = ContentCodec.getInstance().encode(p);
        System.out.println(json);
        Formula f = ContentCodec.getInstance().decode(json);
        System.out.println("predicate: " + f.toString());
    }

    private static class Test
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String value = "hello world";

        private Test() {
        }

        public String toString() {
            return this.value;
        }
    }
}

