/*
 * Decompiled with CFR 0.152.
 */
package astra.reasoner.util;

import astra.core.Intention;
import astra.formula.Formula;
import astra.formula.FormulaVariable;
import astra.formula.IsDone;
import astra.formula.IsNull;
import astra.formula.Predicate;
import astra.reasoner.util.AbstractEvaluateVisitor;
import astra.reasoner.util.LogicVisitor;
import astra.term.ModuleTerm;
import astra.term.NullTerm;
import astra.term.Primitive;
import astra.term.QueryTerm;
import astra.term.Term;
import astra.term.Variable;
import astra.type.Type;
import java.util.HashMap;
import java.util.Map;

public class ContextEvaluateVisitor
extends AbstractEvaluateVisitor {
    private static Map<Class<? extends Formula>, Handler<? extends Formula>> formulaHandlers = new HashMap<Class<? extends Formula>, Handler<? extends Formula>>();
    private static Map<Class<? extends Term>, Handler<? extends Term>> termHandlers = new HashMap<Class<? extends Term>, Handler<? extends Term>>();
    Intention intention;

    public static <T extends Formula> void addFormulaHandler(Handler<T> handler) {
        formulaHandlers.put(handler.getType(), handler);
    }

    public static <T extends Term> void addTermHandler(Handler<T> handler) {
        termHandlers.put(handler.getType(), handler);
    }

    private static <T extends Formula> Handler<Formula> getFormulaHandler(Class<T> cls) {
        return formulaHandlers.get(cls);
    }

    private static <T extends Term> Handler<Term> getTermHandler(Class<T> cls) {
        return termHandlers.get(cls);
    }

    public ContextEvaluateVisitor(Intention intention) {
        this(intention, false);
    }

    public ContextEvaluateVisitor(Intention intention, boolean passByValue) {
        super(passByValue);
        this.intention = intention;
        ContextEvaluateVisitor.addFormulaHandler(new Handler<IsDone>(){

            @Override
            public Class<IsDone> getType() {
                return IsDone.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, IsDone isDone, Intention intention) {
                return intention.isDone() ? Predicate.TRUE : Predicate.FALSE;
            }
        });
    }

    @Override
    public Object visit(Formula formula) {
        Handler<Formula> handler = ContextEvaluateVisitor.getFormulaHandler(formula.getClass());
        if (handler == null) {
            return super.visit(formula);
        }
        return handler.handle(this, formula, this.intention);
    }

    @Override
    public Object visit(Term term) {
        Handler<Term> handler = ContextEvaluateVisitor.getTermHandler(term.getClass());
        if (handler == null) {
            return super.visit(term);
        }
        return handler.handle(this, term, this.intention);
    }

    static {
        ContextEvaluateVisitor.addTermHandler(new Handler<Variable>(){

            @Override
            public Class<Variable> getType() {
                return Variable.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, Variable variable, Intention context) {
                Term term = context.getValue(variable);
                if (term == null || term instanceof Variable) {
                    return variable;
                }
                return term;
            }
        });
        ContextEvaluateVisitor.addTermHandler(new Handler<ModuleTerm>(){

            @Override
            public Class<ModuleTerm> getType() {
                return ModuleTerm.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, ModuleTerm term, Intention context) {
                Object value = term.evaluate(context);
                if (value == null) {
                    return new NullTerm();
                }
                if (Type.getType(value).equals(Type.LIST) || Type.getType(value).equals(Type.FORMULA) || Type.getType(value).equals(Type.FUNCTION)) {
                    return value;
                }
                return Primitive.newPrimitive(value);
            }
        });
        ContextEvaluateVisitor.addTermHandler(new Handler<QueryTerm>(){

            @Override
            public Class<QueryTerm> getType() {
                return QueryTerm.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, QueryTerm term, Intention context) {
                return Primitive.newPrimitive(context.query((Formula)term.formula().accept(visitor)) != null);
            }
        });
        ContextEvaluateVisitor.addFormulaHandler(new Handler<IsNull>(){

            @Override
            public Class<IsNull> getType() {
                return IsNull.class;
            }

            @Override
            public Object handle(LogicVisitor visitor, IsNull isNull, Intention context) {
                Term t = isNull.formula();
                if (t instanceof Variable) {
                    Term term = context.getValue((Variable)t);
                    return term == null ? Predicate.TRUE : Predicate.FALSE;
                }
                if (t instanceof FormulaVariable) {
                    Term term = context.getValue(((FormulaVariable)((Object)t)).variable());
                    return term == null ? Predicate.TRUE : Predicate.FALSE;
                }
                return Predicate.FALSE;
            }
        });
    }

    public static interface Handler<T> {
        public Class<T> getType();

        public Object handle(LogicVisitor var1, T var2, Intention var3);
    }
}

