/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.Term;
import astra.term.Variable;

public class Assignment
extends AbstractStatement {
    Variable variable;
    Term value;

    public Assignment(Variable variable, Term value) {
        this.variable = variable;
        this.value = value;
    }

    public Assignment(Variable variable, String clazz, int[] data, Term value) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.variable = variable;
        this.value = value;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){

            @Override
            public boolean execute(Intention intention) {
                try {
                    intention.updateVariable(Assignment.this.variable, (Term)Assignment.this.value.accept(new ContextEvaluateVisitor(intention, true)));
                }
                catch (Throwable e) {
                    intention.failed("Variable Assignment Failed: " + Assignment.this.variable, e);
                }
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                return false;
            }

            @Override
            public Statement statement() {
                return Assignment.this;
            }

            public String toString() {
                return Assignment.this.variable.toString() + " = " + (Assignment.this.value == null ? "" : Assignment.this.value.toString());
            }
        };
    }
}

