/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.formula.Predicate;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.Term;

public class BeliefUpdate
extends AbstractStatement {
    public static final char ADDITION = '+';
    public static final char DELETION = '-';
    Predicate predicate;
    char op;

    public BeliefUpdate(char op, Predicate predicate) {
        this.op = op;
        this.predicate = predicate;
    }

    public BeliefUpdate(char op, String clazz, int[] data, Predicate predicate) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.op = op;
        this.predicate = predicate;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){

            @Override
            public boolean execute(Intention context) {
                ContextEvaluateVisitor visitor = new ContextEvaluateVisitor(context);
                Term[] terms = new Term[BeliefUpdate.this.predicate.size()];
                for (int i = 0; i < terms.length; ++i) {
                    terms[i] = (Term)BeliefUpdate.this.predicate.getTerm(i).accept(visitor);
                }
                Predicate belief = new Predicate(BeliefUpdate.this.predicate.predicate(), terms);
                if (BeliefUpdate.this.op == '+') {
                    context.addBelief(belief);
                } else if (BeliefUpdate.this.op == '-') {
                    context.removeBelief(belief);
                }
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                return false;
            }

            @Override
            public Statement statement() {
                return BeliefUpdate.this;
            }
        };
    }
}

