/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;

public class Block
extends AbstractStatement {
    Statement[] statements;

    public Block(Statement[] statements) {
        this.statements = statements;
    }

    public Block(String clazz, int[] data, Statement[] statements) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.statements = statements;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){
            int index = 0;

            @Override
            public boolean execute(Intention intention) {
                if (this.index < Block.this.statements.length) {
                    StatementHandler handler = Block.this.statements[this.index++].getStatementHandler();
                    handler.setRuleExecutor(this.executor);
                    this.executor.addStatement(handler);
                }
                return this.index < Block.this.statements.length;
            }

            @Override
            public boolean onFail(Intention intention) {
                return false;
            }

            @Override
            public Statement statement() {
                return Block.this;
            }

            public String toString() {
                return "block: " + this.index + " of " + Block.this.statements.length;
            }
        };
    }

    public String toString() {
        String out = "{\n";
        for (int i = 0; i < this.statements.length; ++i) {
            out = out + this.statements[i].toString() + "\n";
        }
        return out + "}";
    }
}

