/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.Term;
import astra.term.Variable;

public class Declaration
extends AbstractStatement {
    Variable variable;
    Term value;

    public Declaration(Variable variable, Term value) {
        this.variable = variable;
        this.value = value;
    }

    public Declaration(Variable variable, String clazz, int[] data, Term value) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.variable = variable;
        this.value = value;
    }

    public Declaration(Variable variable) {
        this.variable = variable;
    }

    public Declaration(Variable variable, String clazz, int[] data) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.variable = variable;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){

            @Override
            public boolean execute(Intention intention) {
                if (Declaration.this.value == null) {
                    this.executor.addVariable(Declaration.this.variable);
                } else {
                    try {
                        this.executor.addVariable(Declaration.this.variable, (Term)Declaration.this.value.accept(new ContextEvaluateVisitor(intention, true)));
                    }
                    catch (Throwable e) {
                        intention.failed("Variable Declaration Failed: " + Declaration.this.variable, e);
                        return false;
                    }
                }
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                return false;
            }

            @Override
            public Statement statement() {
                return Declaration.this;
            }

            public String toString() {
                return Declaration.this.variable.type() + " " + Declaration.this.variable + (Declaration.this.value == null ? "" : " = " + Declaration.this.value);
            }
        };
    }
}

