/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.formula.Formula;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.reasoner.util.VariableVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.Term;
import astra.term.Variable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ForEach
extends AbstractStatement {
    Formula guard;
    Statement body;

    public ForEach(String clazz, int[] data, Formula guard, Statement body) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.guard = guard;
        this.body = body;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){
            int state = 0;
            List<Map<Integer, Term>> results;
            VariableVisitor visitor;

            @Override
            public boolean execute(Intention intention) {
                switch (this.state) {
                    case 0: {
                        Formula g = (Formula)ForEach.this.guard.accept(new BindingsEvaluateVisitor(this.executor.getAllBindings(), intention.agent));
                        this.visitor = new VariableVisitor();
                        g.accept(this.visitor);
                        try {
                            this.results = intention.queryAll(g);
                            if (this.results == null) {
                                return false;
                            }
                            if (this.results.isEmpty()) {
                                this.executor.addStatement(ForEach.this.body.getStatementHandler(), new HashMap<Integer, Term>());
                                this.state = 2;
                            } else {
                                this.executor.addStatement(ForEach.this.body.getStatementHandler(), this.results.remove(0));
                                this.state = this.results.isEmpty() ? 2 : 1;
                            }
                        }
                        catch (Throwable th) {
                            intention.failed("Failed to match guard", th);
                        }
                        return true;
                    }
                    case 1: {
                        this.executor.addStatement(ForEach.this.body.getStatementHandler(), this.results.remove(0));
                        if (this.results.isEmpty()) {
                            this.state = 2;
                        }
                        return true;
                    }
                    case 2: {
                        for (Variable variable : this.visitor.variables()) {
                            this.executor.removeVariable(variable);
                        }
                        break;
                    }
                }
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                return false;
            }

            @Override
            public Statement statement() {
                return ForEach.this;
            }
        };
    }
}

