/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.formula.Formula;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.Term;
import java.util.Map;

public class If
extends AbstractStatement {
    Formula guard;
    Statement ifStatement;
    Statement elseStatement;

    public If(String clazz, int[] data, Formula guard, Statement ifStatement, Statement elseStatement) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.guard = guard;
        this.ifStatement = ifStatement;
        this.elseStatement = elseStatement;
    }

    public If(String clazz, int[] data, Formula guard, Statement ifStatement) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.guard = guard;
        this.ifStatement = ifStatement;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){

            @Override
            public boolean execute(Intention intention) {
                try {
                    Map<Integer, Term> bindings = intention.query((Formula)If.this.guard.accept(new ContextEvaluateVisitor(intention)));
                    if (bindings == null) {
                        if (If.this.elseStatement == null) {
                            return false;
                        }
                        this.executor.addStatement(If.this.elseStatement.getStatementHandler());
                    } else {
                        this.executor.addStatement(If.this.ifStatement.getStatementHandler(), bindings);
                    }
                }
                catch (Exception th) {
                    intention.failed("Failure matching guard", th);
                }
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                return false;
            }

            @Override
            public Statement statement() {
                return If.this;
            }

            public String toString() {
                return "if (" + If.this.guard + ") ...";
            }
        };
    }
}

