/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.formula.Predicate;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.Term;

public class ScopedBeliefUpdate
extends AbstractStatement {
    String scope;
    Predicate predicate;
    char op;

    public ScopedBeliefUpdate(String scope, char op, Predicate predicate) {
        this.scope = scope;
        this.op = op;
        this.predicate = predicate;
    }

    public ScopedBeliefUpdate(String clazz, int[] data, String scope, char op, Predicate predicate) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.scope = scope;
        this.op = op;
        this.predicate = predicate;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){

            @Override
            public boolean execute(Intention intention) {
                ContextEvaluateVisitor visitor = new ContextEvaluateVisitor(intention);
                Term[] terms = new Term[ScopedBeliefUpdate.this.predicate.size()];
                for (int i = 0; i < terms.length; ++i) {
                    terms[i] = (Term)ScopedBeliefUpdate.this.predicate.getTerm(i).accept(visitor);
                }
                Predicate belief = new Predicate(ScopedBeliefUpdate.this.predicate.predicate(), terms);
                if (ScopedBeliefUpdate.this.op == '+') {
                    intention.addScopedBelief(ScopedBeliefUpdate.this.scope, belief);
                } else if (ScopedBeliefUpdate.this.op == '-') {
                    intention.removeScopedBelief(ScopedBeliefUpdate.this.scope, belief);
                }
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                return false;
            }

            @Override
            public Statement statement() {
                return ScopedBeliefUpdate.this;
            }
        };
    }
}

