/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.event.GoalEvent;
import astra.event.ScopedGoalEvent;
import astra.formula.Formula;
import astra.formula.Goal;
import astra.formula.ScopedGoal;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.reasoner.util.VariableVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.Variable;
import java.util.Queue;

public class ScopedSubgoal
extends AbstractStatement {
    String scope;
    Goal goal;

    public ScopedSubgoal(String scope, Goal goal) {
        this.goal = goal;
    }

    public ScopedSubgoal(String clazz, int[] data, String scope, Goal goal) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.scope = scope;
        this.goal = goal;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){
            Goal gl;
            int index = 0;

            @Override
            public boolean execute(Intention intention) {
                switch (this.index) {
                    case 0: {
                        this.executor = intention.executor();
                        this.gl = (Goal)ScopedSubgoal.this.goal.accept(new ContextEvaluateVisitor(intention));
                        VariableVisitor visitor = new VariableVisitor();
                        this.gl.accept(visitor);
                        for (Variable variable : visitor.variables()) {
                            this.executor.addVariable(variable);
                        }
                        intention.addEvent(new ScopedGoalEvent('+', new ScopedGoal(ScopedSubgoal.this.scope, this.gl), (Object)this.executor));
                        intention.suspend();
                        this.index = 1;
                        return true;
                    }
                    case 1: {
                        intention.addEvent(new ScopedGoalEvent('-', new ScopedGoal(ScopedSubgoal.this.scope, this.gl)));
                    }
                }
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                context.addEvent(new GoalEvent('-', this.gl));
                return false;
            }

            @Override
            public Statement statement() {
                return ScopedSubgoal.this;
            }

            public String toString() {
                if (this.gl == null) {
                    return ScopedSubgoal.this.scope + "::" + ScopedSubgoal.this.goal.toString();
                }
                return ScopedSubgoal.this.scope + "::" + this.gl.toString();
            }

            @Override
            public void addGoals(Queue<Formula> list, Goal goal) {
                if (goal.formula().id() == this.gl.formula().id()) {
                    list.add(this.gl);
                }
            }
        };
    }
}

