/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.formula.Formula;
import astra.formula.ModuleFormula;
import astra.messaging.AstraMessage;
import astra.messaging.MessageService;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.FormulaTerm;
import astra.term.Funct;
import astra.term.ListTerm;
import astra.term.Performative;
import astra.term.Primitive;
import astra.term.Term;
import java.util.HashMap;

public class Send
extends AbstractStatement {
    Term performative;
    Term name;
    Formula content;
    Term params;

    public Send(String clazz, int[] data, Term performative, Term name, Formula content) {
        this(clazz, data, performative, name, content, null);
    }

    public Send(String clazz, int[] data, Term performative, Term name, Formula content, Term params) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.performative = performative;
        this.name = name;
        this.content = content;
        this.params = params;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){

            @Override
            public boolean execute(Intention intention) {
                try {
                    Object parameters;
                    ContextEvaluateVisitor visitor = new ContextEvaluateVisitor(intention);
                    AstraMessage message = new AstraMessage();
                    message.sender = intention.name();
                    Term receiver = (Term)Send.this.name.accept(visitor);
                    if (Primitive.class.isInstance(receiver)) {
                        message.receivers.add((String)((Primitive)receiver).value());
                    } else {
                        for (Object term : (ListTerm)receiver) {
                            message.receivers.add((String)((Primitive)term).value());
                        }
                    }
                    if (Send.this.params != null && ListTerm.class.isInstance(parameters = Send.this.params.accept(visitor))) {
                        for (Term t : (ListTerm)parameters) {
                            if (!Funct.class.isInstance(t)) continue;
                            Funct funct = (Funct)((Funct)t).accept(visitor);
                            if (funct.size() > 1) {
                                intention.failed("Unexpected Param in send(...): " + funct);
                                return false;
                            }
                            if (funct.functor().equals("protocol")) {
                                message.protocol = ((Primitive)funct.termAt(0)).value().toString();
                                continue;
                            }
                            if (funct.functor().equals("conversation_id")) {
                                message.conversationId = ((Primitive)funct.termAt(0)).value().toString();
                                continue;
                            }
                            intention.failed("Unexpected Param in send(...): " + funct);
                            return false;
                        }
                    }
                    BindingsEvaluateVisitor bvisitor = new BindingsEvaluateVisitor(this.executor.bindings(), intention.agent);
                    message.performative = ((Performative)Send.this.performative.accept(visitor)).value();
                    Formula ctnt = null;
                    Object cnt = ((Formula)Send.this.content.accept(bvisitor)).accept(visitor);
                    if (cnt instanceof FormulaTerm) {
                        ctnt = ((FormulaTerm)cnt).value();
                    } else if (cnt instanceof ModuleFormula) {
                        ctnt = ((ModuleFormula)cnt).adaptor().invoke(new BindingsEvaluateVisitor(new HashMap<Integer, Term>(), intention.agent), ((ModuleFormula)cnt).predicate());
                    } else if (cnt instanceof Formula) {
                        ctnt = (Formula)cnt;
                    } else {
                        intention.failed("Invalid Formula type: " + cnt.getClass().getCanonicalName());
                        return false;
                    }
                    message.content = ctnt;
                    if (!MessageService.send(message)) {
                        System.out.println("Problem sending: " + message);
                        intention.failed("Failed to send message");
                    }
                }
                catch (Exception th) {
                    intention.failed("Unexpected Error", th);
                }
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                return false;
            }

            @Override
            public Statement statement() {
                return Send.this;
            }

            public String toString() {
                return "send(" + Send.this.performative + "," + Send.this.name + "," + Send.this.content + ")";
            }
        };
    }
}

