/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.event.GoalEvent;
import astra.formula.Goal;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;

public class SpawnGoal
extends AbstractStatement {
    Goal goal;

    public SpawnGoal(Goal goal) {
        this.goal = goal;
    }

    public SpawnGoal(String clazz, int[] data, Goal goal) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.goal = goal;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){
            Goal gl;

            @Override
            public boolean execute(Intention context) {
                this.gl = (Goal)SpawnGoal.this.goal.accept(new ContextEvaluateVisitor(context));
                context.addGoal(this.gl);
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                context.addEvent(new GoalEvent('-', this.gl));
                return false;
            }

            @Override
            public Statement statement() {
                return SpawnGoal.this;
            }

            public String toString() {
                if (this.gl == null) {
                    return SpawnGoal.this.goal.toString();
                }
                return this.gl.toString();
            }
        };
    }
}

