/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.formula.Predicate;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.Term;
import astra.term.Variable;
import java.util.List;
import java.util.Map;

public class SpecialBeliefUpdate
extends AbstractStatement {
    Predicate predicate;

    public SpecialBeliefUpdate(Predicate predicate) {
        this.predicate = predicate;
    }

    public SpecialBeliefUpdate(String clazz, int[] data, Predicate predicate) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.predicate = predicate;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){

            @Override
            public boolean execute(Intention intention) {
                ContextEvaluateVisitor visitor = new ContextEvaluateVisitor(intention);
                Term[] terms = new Term[SpecialBeliefUpdate.this.predicate.size()];
                Term[] variables = new Term[SpecialBeliefUpdate.this.predicate.size()];
                for (int i = 0; i < terms.length; ++i) {
                    terms[i] = (Term)SpecialBeliefUpdate.this.predicate.getTerm(i).accept(visitor);
                    variables[i] = new Variable(SpecialBeliefUpdate.this.predicate.getTerm(i).type(), "_" + i);
                }
                Predicate belief = new Predicate(SpecialBeliefUpdate.this.predicate.predicate(), terms);
                Predicate matcher = new Predicate(SpecialBeliefUpdate.this.predicate.predicate(), variables);
                boolean matched = false;
                List<Map<Integer, Term>> bindings = intention.queryAll(matcher);
                if (bindings != null) {
                    for (Map<Integer, Term> binding : bindings) {
                        Predicate bel = (Predicate)matcher.accept(new BindingsEvaluateVisitor(binding, intention.agent));
                        if (bel.equals(belief)) {
                            matched = true;
                            continue;
                        }
                        intention.removeBelief(bel);
                    }
                }
                if (!matched) {
                    intention.addBelief(belief);
                }
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                return false;
            }

            @Override
            public Statement statement() {
                return SpecialBeliefUpdate.this;
            }
        };
    }
}

