/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.event.GoalEvent;
import astra.formula.Formula;
import astra.formula.Goal;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.reasoner.util.VariableVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.Variable;
import java.util.Queue;

public class Subgoal
extends AbstractStatement {
    Goal goal;

    public Subgoal(Goal goal) {
        this.goal = goal;
    }

    public Subgoal(String clazz, int[] data, Goal goal) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.goal = goal;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){
            Goal gl;
            int index = 0;

            @Override
            public boolean execute(Intention intention) {
                switch (this.index) {
                    case 0: {
                        this.executor = intention.executor();
                        this.gl = (Goal)Subgoal.this.goal.accept(new ContextEvaluateVisitor(intention));
                        VariableVisitor visitor = new VariableVisitor();
                        this.gl.accept(visitor);
                        for (Variable variable : visitor.variables()) {
                            this.executor.addVariable(variable);
                        }
                        intention.addEvent(new GoalEvent('+', this.gl, this.executor));
                        intention.suspend();
                        this.index = 1;
                        return true;
                    }
                    case 1: {
                        intention.addEvent(new GoalEvent('-', this.gl));
                    }
                }
                return false;
            }

            @Override
            public boolean onFail(Intention context) {
                context.addEvent(new GoalEvent('-', this.gl));
                return false;
            }

            @Override
            public Statement statement() {
                return Subgoal.this;
            }

            public String toString() {
                if (this.gl == null) {
                    return Subgoal.this.goal.toString();
                }
                return this.gl.toString();
            }

            @Override
            public void addGoals(Queue<Formula> list, Goal goal) {
                if (goal.formula().id() == this.gl.formula().id()) {
                    list.add(this.gl);
                }
            }
        };
    }
}

