/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Intention;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;

public class SynchronizedBlock
extends AbstractStatement {
    Statement statement;
    String token;

    public SynchronizedBlock(String clazz, int[] data, String token, Statement statement) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.token = token;
        this.statement = statement;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){
            int state = 0;

            @Override
            public boolean execute(Intention context) {
                if (this.state == 0 && context.hasLock(SynchronizedBlock.this.token, context)) {
                    this.executor.addStatement(SynchronizedBlock.this.statement.getStatementHandler());
                } else {
                    switch (this.state) {
                        case 0: {
                            ++this.state;
                            if (!context.requestLock(SynchronizedBlock.this.token, context)) break;
                        }
                        case 1: {
                            if (!context.hasLock(SynchronizedBlock.this.token, context)) {
                                System.out.println("Still waiting for token: " + SynchronizedBlock.this.token);
                                break;
                            }
                            ++this.state;
                            this.executor.addStatement(SynchronizedBlock.this.statement.getStatementHandler());
                            break;
                        }
                        case 2: {
                            context.releaseLock(SynchronizedBlock.this.token, context);
                            return false;
                        }
                    }
                }
                return true;
            }

            @Override
            public boolean onFail(Intention context) {
                if (this.state == 2) {
                    context.releaseLock(SynchronizedBlock.this.token, context);
                } else {
                    context.unrequestLock(SynchronizedBlock.this.token, context);
                }
                return false;
            }

            @Override
            public Statement statement() {
                return SynchronizedBlock.this;
            }
        };
    }
}

