/*
 * Decompiled with CFR 0.152.
 */
package astra.statement;

import astra.core.Agent;
import astra.core.Intention;
import astra.formula.Formula;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.statement.AbstractStatement;
import astra.statement.AbstractStatementHandler;
import astra.statement.Statement;
import astra.statement.StatementHandler;
import astra.term.Primitive;
import astra.term.Term;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Wait
extends AbstractStatement {
    Formula guard;
    Term timeout;

    public Wait(String clazz, int[] data, Formula guard) {
        this(clazz, data, guard, null);
    }

    public Wait(String clazz, int[] data, Formula guard, Term timeout) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.guard = guard;
        this.timeout = timeout;
    }

    @Override
    public StatementHandler getStatementHandler() {
        return new AbstractStatementHandler(){
            int state = 0;
            Agent.Promise promise;

            @Override
            public boolean execute(final Intention intention) {
                switch (this.state) {
                    case 1: {
                        this.state = 0;
                        return true;
                    }
                    case 0: {
                        final ContextEvaluateVisitor visitor = new ContextEvaluateVisitor(intention);
                        this.promise = Wait.this.timeout == null ? new Agent.Promise(){
                            List<Map<Integer, Term>> bindings;
                            Formula formula;
                            {
                                this.formula = (Formula)Wait.this.guard.accept(visitor);
                            }

                            @Override
                            public boolean evaluate(Agent agent) {
                                this.bindings = agent.query(this.formula, new HashMap<Integer, Term>());
                                return this.bindings != null;
                            }

                            @Override
                            public void act() {
                                if (this.bindings != null) {
                                    executor.addBindings(this.bindings.get(0));
                                }
                                intention.resume();
                            }
                        } : new Agent.Promise(){
                            List<Map<Integer, Term>> bindings;
                            Formula formula;
                            long delay;
                            long startTime;
                            {
                                this.formula = (Formula)Wait.this.guard.accept(visitor);
                                this.delay = ((Integer)((Primitive)Wait.this.timeout.accept(visitor)).value()).intValue();
                                this.startTime = System.currentTimeMillis();
                            }

                            @Override
                            public boolean evaluate(Agent agent) {
                                this.bindings = agent.query(this.formula, new HashMap<Integer, Term>());
                                long duration = System.currentTimeMillis() - this.startTime;
                                return this.bindings != null || duration >= this.delay;
                            }

                            @Override
                            public void act() {
                                if (this.bindings != null) {
                                    executor.addBindings(this.bindings.get(0));
                                }
                                intention.resume();
                            }
                        };
                        intention.makePromise(this.promise);
                        intention.suspend();
                        this.state = 1;
                    }
                }
                return false;
            }

            @Override
            public boolean onFail(Intention intention) {
                intention.dropPromise(this.promise);
                return false;
            }

            @Override
            public Statement statement() {
                return Wait.this;
            }
        };
    }
}

