/*
 * Decompiled with CFR 0.152.
 */
package astra.term;

import astra.reasoner.util.LogicVisitor;
import astra.term.Term;
import astra.type.Type;

public class FromJson
implements Term {
    private static final long serialVersionUID = 6908458811392703018L;
    Term term;
    String type;

    public FromJson(Term term, String type) {
        this.term = term;
        this.type = type;
    }

    @Override
    public Type type() {
        return Type.OBJECT;
    }

    @Override
    public Object accept(LogicVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean matches(Term right) {
        if (!FromJson.class.isInstance(right)) {
            return false;
        }
        return this.term.matches(((FromJson)right).term);
    }

    public boolean equals(Object object) {
        return object instanceof FromJson;
    }

    @Override
    public String signature() {
        return "FJ:" + this.term.signature();
    }

    @Override
    public FromJson clone() {
        return this;
    }

    public Term term() {
        return this.term;
    }

    public String toString() {
        return "from_json(" + this.term + "," + this.type + ")";
    }

    public Class<?> getSpecifiedType() {
        try {
            return Class.forName(this.type);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String rawType() {
        return this.type;
    }
}

