/*
 * Decompiled with CFR 0.152.
 */
package astra.term;

import astra.reasoner.util.LogicVisitor;
import astra.reasoner.util.StringMapper;
import astra.term.Term;
import astra.type.Type;

public class Funct
implements Term {
    private static final long serialVersionUID = -5262384951018591053L;
    private static StringMapper mapper;
    private int id;
    Term[] terms;

    public Funct(String predicate, Term[] terms) {
        if (mapper == null) {
            mapper = new StringMapper();
        }
        this.id = mapper.toId(predicate);
        this.terms = terms;
    }

    private Funct(int id, Term[] terms) {
        this.id = id;
        this.terms = terms;
    }

    public Term getTerm(int i) {
        return this.terms[i];
    }

    public int size() {
        return this.terms.length;
    }

    public int id() {
        return this.id;
    }

    public Term[] terms() {
        return this.terms;
    }

    public String toString() {
        String out = mapper.fromId(this.id);
        out = out + "(";
        if (this.terms.length > 0) {
            for (int i = 0; i < this.terms.length; ++i) {
                if (i > 0) {
                    out = out + ",";
                }
                out = out + this.terms[i].toString();
            }
        }
        out = out + ")";
        return out;
    }

    @Override
    public Object accept(LogicVisitor visitor) {
        return visitor.visit(this);
    }

    public String functor() {
        return mapper.fromId(this.id);
    }

    @Override
    public boolean matches(Term term) {
        if (term instanceof Funct) {
            Funct f = (Funct)term;
            if (f.id != this.id || f.size() != this.terms.length) {
                return false;
            }
            for (int i = 0; i < this.terms.length; ++i) {
                if (this.terms[i].matches(f.getTerm(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof Funct) {
            Funct p = (Funct)object;
            if (p.id != this.id || p.size() != this.terms.length) {
                return false;
            }
            for (int i = 0; i < this.terms.length; ++i) {
                if (this.terms[i].equals(p.getTerm(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Term termAt(int i) {
        return this.terms[i];
    }

    @Override
    public Type type() {
        return Type.FUNCTION;
    }

    @Override
    public String signature() {
        return this.id + ":" + this.terms.length;
    }

    public void set(int i, Term term) {
        this.terms[i] = term;
    }

    @Override
    public Funct clone() {
        Term[] values = new Term[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            values[i] = this.terms[i].clone();
        }
        return new Funct(this.id, this.terms);
    }
}

