/*
 * Decompiled with CFR 0.152.
 */
package astra.term;

import astra.reasoner.util.LogicVisitor;
import astra.term.Term;
import astra.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ListTerm
implements Term,
List<Term> {
    private static final long serialVersionUID = -6657715322908439651L;
    private List<Term> terms;

    public ListTerm(Term[] terms) {
        this.terms = new ArrayList<Term>();
        this.terms.addAll(Arrays.asList(terms));
    }

    public ListTerm() {
        this.terms = new ArrayList<Term>();
    }

    private ListTerm(List<Term> terms) {
        this.terms = terms;
    }

    @Override
    public Type type() {
        return Type.LIST;
    }

    @Override
    public Object accept(LogicVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean matches(Term right) {
        return false;
    }

    @Override
    public String signature() {
        return "LST";
    }

    @Override
    public int size() {
        return this.terms.size();
    }

    @Override
    public Term get(int i) {
        return this.terms.get(i);
    }

    public Term[] terms() {
        return this.terms.toArray(new Term[this.terms.size()]);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ListTerm) {
            ListTerm term = (ListTerm)object;
            if (this.terms.size() != term.terms.size()) {
                return false;
            }
            for (int i = 0; i < term.terms.size(); ++i) {
                if (this.terms.get(i).equals(term.terms.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object merge(ListTerm r) {
        int i;
        Term[] newTerms = new Term[this.terms.size() + r.terms.size()];
        for (i = 0; i < Math.min(this.terms.size(), r.terms.size()); ++i) {
            newTerms[i] = this.terms.get(i);
            newTerms[i + this.terms.size()] = r.terms.get(i);
        }
        while (i < this.terms.size()) {
            newTerms[i] = this.terms.get(i);
            ++i;
        }
        while (i < r.terms.size()) {
            newTerms[i + this.terms.size()] = r.terms.get(i);
            ++i;
        }
        return new ListTerm(newTerms);
    }

    public String toString() {
        String out = "[";
        for (int i = 0; i < this.terms.size(); ++i) {
            if (i > 0) {
                out = out + ",";
            }
            out = out + this.terms.get(i).toString();
        }
        return out + "]";
    }

    @Override
    public void clear() {
        this.terms.clear();
    }

    @Override
    public int indexOf(Object object) {
        return this.terms.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.terms.isEmpty();
    }

    @Override
    public Iterator<Term> iterator() {
        return this.terms.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.terms.lastIndexOf(object);
    }

    @Override
    public ListIterator<Term> listIterator() {
        return this.terms.listIterator();
    }

    @Override
    public ListIterator<Term> listIterator(int index) {
        return this.terms.listIterator(index);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.terms.remove(arg0);
    }

    public ListTerm subList(int arg0, int arg1) {
        return new ListTerm(this.terms.subList(arg0, arg1));
    }

    public Term[] toArray() {
        return this.terms.toArray(new Term[this.size()]);
    }

    @Override
    public boolean add(Term e) {
        return this.terms.add(e);
    }

    @Override
    public void add(int index, Term element) {
        this.terms.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends Term> c) {
        return this.terms.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Term> c) {
        return this.terms.addAll(index, c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.terms.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.terms.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.terms.retainAll(c);
    }

    @Override
    public Term set(int index, Term element) {
        return this.terms.set(index, element);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.terms.toArray(a);
    }

    @Override
    public boolean contains(Object o) {
        return this.terms.contains(o);
    }

    @Override
    public Term remove(int index) {
        return this.terms.remove(index);
    }

    @Override
    public ListTerm clone() {
        ListTerm values = new ListTerm();
        for (Term term : this) {
            values.add(term.clone());
        }
        return values;
    }
}

