/*
 * Decompiled with CFR 0.152.
 */
package astra.term;

import astra.core.Intention;
import astra.formula.Predicate;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.reasoner.util.ContextEvaluateVisitor;
import astra.reasoner.util.LogicVisitor;
import astra.term.ModuleTermAdaptor;
import astra.term.Term;
import astra.type.Type;

public class ModuleTerm
implements Term {
    private static final long serialVersionUID = 596832607031187737L;
    String module;
    Predicate method;
    ModuleTermAdaptor adaptor;
    Type type;

    public ModuleTerm(ModuleTermAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    public ModuleTerm(String module, Type type, Predicate method, ModuleTermAdaptor adaptor) {
        this.module = module;
        this.type = type;
        this.method = method;
        this.adaptor = adaptor;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public Object accept(LogicVisitor visitor) {
        return visitor.visit(this);
    }

    public Predicate method() {
        return this.method;
    }

    @Override
    public boolean matches(Term right) {
        return false;
    }

    public Object evaluate(Intention context) {
        return this.adaptor.invoke(context, (Predicate)this.method.accept(new ContextEvaluateVisitor(context)));
    }

    public Object evaluate(BindingsEvaluateVisitor visitor) {
        return this.adaptor.invoke(visitor, (Predicate)this.method.accept(visitor));
    }

    public boolean equals(Object object) {
        if (object instanceof ModuleTerm) {
            ModuleTerm term = (ModuleTerm)object;
            return term.module.equals(this.module) && term.method.equals(this.method);
        }
        return false;
    }

    public String toString() {
        return "Module Term: " + this.module + "." + this.method;
    }

    @Override
    public String signature() {
        return null;
    }

    public ModuleTermAdaptor adaptor() {
        return this.adaptor;
    }

    public String module() {
        return this.module;
    }

    @Override
    public ModuleTerm clone() {
        return this;
    }
}

