/*
 * Decompiled with CFR 0.152.
 */
package astra.term;

import astra.reasoner.util.LogicVisitor;
import astra.term.Term;
import astra.type.Type;

public class Operator
implements Term {
    private static final long serialVersionUID = 7716467315864657239L;
    public static final char PLUS = '+';
    public static final char MINUS = '-';
    public static final char MULTIPLY = '*';
    public static final char DIVIDE = '/';
    public static final char MODULO = '%';
    private char op;
    private Term left;
    private Term right;
    private Type type;

    protected Operator(char op, Type type, Term left, Term right) {
        this.op = op;
        this.type = type;
        this.left = left;
        this.right = right;
    }

    public static Operator newOperator(char op, Term left, Term right) {
        if (left.type().equals(right.type())) {
            return new Operator(op, left.type(), left, right);
        }
        return new Operator(op, Type.getMostGeneralType(left.type(), right.type()), left, right);
    }

    public char op() {
        return this.op;
    }

    public Term left() {
        return this.left;
    }

    public Term right() {
        return this.right;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public Object accept(LogicVisitor visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        return this.left.toString() + this.op + this.right.toString();
    }

    @Override
    public boolean matches(Term term) {
        return this.type.equals(term.type());
    }

    public boolean equals(Object object) {
        if (object instanceof Operator) {
            Operator op = (Operator)object;
            return op.left.equals(this.left) && op.right.equals(this.right);
        }
        return false;
    }

    @Override
    public String signature() {
        return null;
    }

    @Override
    public Operator clone() {
        return new Operator(this.op, this.type, this.left.clone(), this.right.clone());
    }
}

