/*
 * Decompiled with CFR 0.152.
 */
package astra.term;

import astra.reasoner.util.LogicVisitor;
import astra.reasoner.util.StringMapper;
import astra.term.Term;
import astra.term.Variable;
import astra.type.Type;

public class Performative
implements Term {
    private static final long serialVersionUID = -5641472519856863137L;
    private static StringMapper mapper = new StringMapper();
    private int stringId;

    public Performative(String value) {
        this.stringId = mapper.toId(value);
    }

    public int stringId() {
        return this.stringId;
    }

    public String value() {
        return mapper.fromId(this.stringId);
    }

    @Override
    public Type type() {
        return Type.PERFORMATIVE;
    }

    public String toString() {
        return "\"" + mapper.fromId(this.stringId) + "\"";
    }

    public boolean equals(Object obj) {
        if (Performative.class.isInstance(obj)) {
            return ((Performative)obj).stringId == this.stringId;
        }
        return false;
    }

    @Override
    public Object accept(LogicVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean matches(Term term) {
        if (term instanceof Performative) {
            return this.stringId == ((Performative)term).stringId;
        }
        return term instanceof Variable;
    }

    @Override
    public String signature() {
        return "PE:" + this.stringId;
    }

    @Override
    public Performative clone() {
        return this;
    }
}

