/*
 * Decompiled with CFR 0.152.
 */
package astra.term;

import astra.reasoner.util.LogicVisitor;
import astra.term.Term;
import astra.type.Type;

public class Primitive<T>
implements Term {
    private static final long serialVersionUID = -2413410722868716733L;
    private Type type;
    private T value;

    public Primitive(Type type, T value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public Object accept(LogicVisitor visitor) {
        return visitor.visit(this);
    }

    public T value() {
        return this.value;
    }

    public static <T> Primitive<T> newPrimitive(T value) {
        return new Primitive<T>(Type.getType(value), value);
    }

    public String toString() {
        if (this.type.equals(Type.STRING)) {
            return "\"" + this.value.toString() + "\"";
        }
        return this.value.toString();
    }

    @Override
    public boolean matches(Term term) {
        return this.type.equals(term.type());
    }

    public boolean equals(Object object) {
        if (object instanceof Primitive) {
            return this.type.equals(((Primitive)object).type()) && this.value.equals(((Primitive)object).value);
        }
        return false;
    }

    @Override
    public String signature() {
        return "PR:" + this.value;
    }

    @Override
    public Primitive<T> clone() {
        return this;
    }
}

