/*
 * Decompiled with CFR 0.152.
 */
package astra.term;

import astra.reasoner.util.LogicVisitor;
import astra.reasoner.util.StringMapper;
import astra.term.Term;
import astra.type.Type;

public class Variable
implements Term {
    private static final long serialVersionUID = 8088567323537166255L;
    public static StringMapper mapper = new StringMapper();
    private Type type;
    private int id;
    private boolean returns;

    public Variable(Type type, String name) {
        this(type, name, false);
    }

    public Variable(Type type, String name, boolean returns) {
        this.id = mapper.toId(name);
        this.type = type;
        this.returns = returns;
    }

    public Variable(Type type, int key) {
        this.id = key;
        this.type = type;
    }

    @Override
    public Type type() {
        return this.type;
    }

    public int id() {
        return this.id;
    }

    public String identifier() {
        return mapper.fromId(this.id);
    }

    @Override
    public Object accept(LogicVisitor visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return mapper.fromId(this.id) + ":" + this.id;
    }

    @Override
    public boolean matches(Term right) {
        return this.type.equals(right.type());
    }

    public boolean returns() {
        return this.returns;
    }

    @Override
    public String signature() {
        return null;
    }

    @Override
    public Variable clone() {
        return this;
    }
}

