/*
 * Decompiled with CFR 0.152.
 */
package astra.tr;

import astra.formula.Predicate;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.term.Term;
import astra.tr.AbstractAction;
import astra.tr.ActionHandler;
import astra.tr.TRContext;
import java.util.Map;

public class TRBeliefUpdate
extends AbstractAction {
    public static final char ADDITION = '+';
    public static final char DELETION = '-';
    Predicate predicate;
    char op;

    public TRBeliefUpdate(char op, String clazz, int[] data, Predicate predicate) {
        this.setLocation(clazz, data[0], data[1], data[2], data[3]);
        this.op = op;
        this.predicate = predicate;
    }

    @Override
    public ActionHandler getStatementHandler() {
        return new ActionHandler(){

            @Override
            public boolean execute(TRContext context, Map<Integer, Term> bindings) {
                BindingsEvaluateVisitor visitor = new BindingsEvaluateVisitor(bindings, context.agent);
                Term[] terms = new Term[TRBeliefUpdate.this.predicate.size()];
                for (int i = 0; i < terms.length; ++i) {
                    terms[i] = (Term)TRBeliefUpdate.this.predicate.getTerm(i).accept(visitor);
                }
                Predicate belief = new Predicate(TRBeliefUpdate.this.predicate.predicate(), terms);
                if (TRBeliefUpdate.this.op == '+') {
                    context.addBelief(belief);
                } else if (TRBeliefUpdate.this.op == '-') {
                    context.removeBelief(belief);
                }
                return true;
            }
        };
    }
}

