/*
 * Decompiled with CFR 0.152.
 */
package astra.tr;

import astra.core.AbstractTask;
import astra.core.Agent;
import astra.core.Module;
import astra.formula.Formula;
import astra.formula.Predicate;
import astra.reasoner.Unifier;
import astra.reasoner.util.BindingsEvaluateVisitor;
import astra.term.Primitive;
import astra.term.Term;
import astra.tr.Function;
import astra.tr.TRRule;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TRContext {
    List<Predicate> trace = new LinkedList<Predicate>();
    Agent agent;
    int index;

    public TRContext(Agent agent, Predicate call) {
        this.agent = agent;
        this.trace.add(call);
    }

    public <T> T getValue(Term term) {
        if (term instanceof Primitive) {
            return ((Primitive)term).value();
        }
        return null;
    }

    public Module getModule(String classname, String key) {
        return this.agent.getModule(classname, key);
    }

    public boolean execute() {
        block0: for (int index = 0; index < this.trace.size(); ++index) {
            Function function = this.agent.getFunction(this.trace.get(index));
            Map<Integer, Term> bindings = Unifier.unify(function.identifier, this.trace.get(index), this.agent);
            if (bindings == null) {
                System.err.println("ERROR EXECUTING TR FUNCTION: " + this.trace.get(index));
                for (int i = this.trace.size() - 1; i >= 0; --i) {
                    System.err.println(this.trace.get(i));
                }
                return false;
            }
            for (TRRule rule : function.rules) {
                HashMap<Integer, Term> b = new HashMap<Integer, Term>();
                b.putAll(bindings);
                Formula cond = (Formula)rule.condition.accept(new BindingsEvaluateVisitor(b, this.agent));
                List<Map<Integer, Term>> result = this.agent.query(cond, b);
                if (result == null) continue;
                if (!result.isEmpty()) {
                    bindings.putAll(result.get(0));
                }
                rule.execute(this, bindings);
                continue block0;
            }
        }
        return true;
    }

    public void callFunction(Predicate call) {
        this.trace.add(call);
    }

    public void addBelief(Predicate belief) {
        this.agent.beliefs().addBelief(belief);
    }

    public void removeBelief(Predicate belief) {
        this.agent.beliefs().dropBelief(belief);
    }

    public String name() {
        return this.agent.name();
    }

    public void schedule(AbstractTask task) {
        this.agent.schedule(task);
    }

    public void stopFunction() {
        this.agent.stopFunction();
    }
}

