/*
 * Decompiled with CFR 0.152.
 */
package astra.trace;

import astra.trace.TraceEvent;
import astra.trace.TraceEventListener;
import astra.trace.TraceRecorder;
import java.util.LinkedList;
import java.util.List;

public class TraceManager {
    private static TraceManager manager;
    private List<TraceEventListener> listeners = new LinkedList<TraceEventListener>();
    private TraceRecorder recorder;

    public static TraceManager getInstance() {
        if (manager == null) {
            manager = new TraceManager();
        }
        return manager;
    }

    public void setTraceRecorder(TraceRecorder _recorder) {
        this.recorder = _recorder;
    }

    public void addListener(TraceEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TraceEventListener listener) {
        this.listeners.remove(listener);
    }

    public void recordEvent(TraceEvent event) {
        if (this.recorder != null) {
            this.recorder.record(event);
        }
        for (TraceEventListener listener : this.listeners) {
            listener.update(event);
        }
    }
}

