/*
 * Decompiled with CFR 0.152.
 */
package astra.type;

import astra.reasoner.util.StringMapper;
import astra.term.FormulaTerm;
import astra.term.Funct;
import astra.term.ListTerm;
import astra.term.NullTerm;
import astra.term.Primitive;
import astra.term.Term;
import astra.type.ObjectType;
import astra.type.UnsupportedTypeCastException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Type
implements Serializable {
    private static final long serialVersionUID = 7243904298590334388L;
    private static StringMapper mapper = new StringMapper();
    public static final Type STRING = new Type("string");
    public static final Type CHAR = new Type("char");
    public static final Type INTEGER = new Type("integer");
    public static final Type LONG = new Type("long");
    public static final Type FLOAT = new Type("float");
    public static final Type DOUBLE = new Type("double");
    public static final Type BOOLEAN = new Type("boolean");
    public static final Type PERFORMATIVE = new Type("performative");
    public static final Type OBJECT = new Type("object");
    public static final Type LIST = new Type("list");
    public static final Type FORMULA = new Type("formula");
    public static final Term NO_VALUE = new NullTerm();
    public static final Type FUNCTION = new Type("function");
    static List<Type> types = new ArrayList<Type>();
    private int id;

    public Type(String type) {
        this.id = mapper.toId(type);
    }

    public boolean equals(Type type) {
        return this.id == type.id;
    }

    public static Type getType(Object obj) {
        if (obj instanceof Character) {
            return CHAR;
        }
        if (obj instanceof String) {
            return STRING;
        }
        if (obj instanceof Integer) {
            return INTEGER;
        }
        if (obj instanceof Long) {
            return LONG;
        }
        if (obj instanceof Float) {
            return FLOAT;
        }
        if (obj instanceof Double) {
            return DOUBLE;
        }
        if (obj instanceof Boolean) {
            return BOOLEAN;
        }
        if (obj instanceof ListTerm) {
            return LIST;
        }
        if (obj instanceof Funct) {
            return FUNCTION;
        }
        if (obj instanceof FormulaTerm) {
            return FORMULA;
        }
        return new ObjectType(obj.getClass());
    }

    public static Term defaultValue(Type type) {
        if (type.equals(STRING)) {
            return Primitive.newPrimitive("");
        }
        if (type.equals(INTEGER)) {
            return Primitive.newPrimitive(0);
        }
        if (type.equals(LONG)) {
            return Primitive.newPrimitive(0L);
        }
        if (type.equals(FLOAT)) {
            return Primitive.newPrimitive(Float.valueOf(0.0f));
        }
        if (type.equals(DOUBLE)) {
            return Primitive.newPrimitive(0.0);
        }
        if (type.equals(CHAR)) {
            return Primitive.newPrimitive(Character.valueOf(' '));
        }
        if (type.equals(BOOLEAN)) {
            return Primitive.newPrimitive(false);
        }
        System.out.println("Type has no default: " + type.toString());
        return null;
    }

    public String toString() {
        return mapper.fromId(this.id);
    }

    public static boolean isNumeric(Type type) {
        return type.equals(INTEGER) || type.equals(LONG) || type.equals(FLOAT) || type.equals(DOUBLE);
    }

    public static int integerValue(Term term) {
        if (term.type().equals(INTEGER)) {
            return (Integer)((Primitive)term).value();
        }
        throw new UnsupportedTypeCastException("Attempted to convert: " + term + " of type: " + term.type() + " to an integer");
    }

    public static long longValue(Term term) {
        if (term.type().equals(INTEGER)) {
            return ((Integer)((Primitive)term).value()).intValue();
        }
        if (term.type().equals(LONG)) {
            return (Long)((Primitive)term).value();
        }
        throw new UnsupportedTypeCastException("Attempted to convert: " + term + " of type: " + term.type() + " to a long");
    }

    public static float floatValue(Term term) {
        if (term.type().equals(INTEGER)) {
            return ((Integer)((Primitive)term).value()).intValue();
        }
        if (term.type().equals(LONG)) {
            return ((Long)((Primitive)term).value()).longValue();
        }
        if (term.type().equals(FLOAT)) {
            return ((Float)((Primitive)term).value()).floatValue();
        }
        throw new UnsupportedTypeCastException("Attempted to convert: " + term + " of type: " + term.type() + " to a long");
    }

    public static double doubleValue(Term term) {
        if (term.type().equals(INTEGER)) {
            return ((Integer)((Primitive)term).value()).intValue();
        }
        if (term.type().equals(LONG)) {
            return ((Long)((Primitive)term).value()).longValue();
        }
        if (term.type().equals(FLOAT)) {
            return ((Float)((Primitive)term).value()).floatValue();
        }
        if (term.type().equals(DOUBLE)) {
            return (Double)((Primitive)term).value();
        }
        throw new UnsupportedTypeCastException("Attempted to convert: " + term + " of type: " + term.type() + " to a long");
    }

    public static String stringValue(Term term) {
        if (term instanceof NullTerm) {
            return "null";
        }
        if (term.type().equals(BOOLEAN)) {
            return ((Boolean)((Primitive)term).value()).toString();
        }
        if (term.type().equals(INTEGER)) {
            return ((Integer)((Primitive)term).value()).toString();
        }
        if (term.type().equals(LONG)) {
            return ((Long)((Primitive)term).value()).toString();
        }
        if (term.type().equals(FLOAT)) {
            return ((Float)((Primitive)term).value()).toString();
        }
        if (term.type().equals(DOUBLE)) {
            return ((Double)((Primitive)term).value()).toString();
        }
        if (term.type().equals(CHAR)) {
            return ((Character)((Primitive)term).value()).toString();
        }
        if (term.type().equals(STRING)) {
            return (String)((Primitive)term).value();
        }
        if (term.type() instanceof ObjectType) {
            return ((Primitive)term).value().toString();
        }
        if (term.type().equals(FORMULA)) {
            return ((FormulaTerm)term).value().toString();
        }
        if (term.type().equals(FUNCTION)) {
            if (term instanceof Primitive) {
                return ((Funct)((Primitive)term).value()).toString();
            }
            return ((Funct)term).toString();
        }
        if (term.type().equals(LIST)) {
            return ((ListTerm)term).toString();
        }
        throw new UnsupportedTypeCastException("Attempted to convert: " + term + " of type: " + term.type() + " to a long");
    }

    public static Type getMostGeneralType(Type type, Type type2) {
        return types.indexOf(type) < types.indexOf(type2) ? type2 : type;
    }

    public static boolean isNumeric(Term il) {
        return Type.isNumeric(il.type());
    }

    static {
        types.add(BOOLEAN);
        types.add(CHAR);
        types.add(INTEGER);
        types.add(LONG);
        types.add(FLOAT);
        types.add(DOUBLE);
        types.add(FUNCTION);
        types.add(STRING);
    }
}

