/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.api;

import com.authlete.common.api.AuthleteApi;
import com.authlete.common.conf.AuthleteConfiguration;
import java.lang.reflect.Constructor;

public class AuthleteApiFactory {
    private static final String[] sKnownImpls = new String[]{"com.authlete.client.jaxrs.api.AuthleteApiImpl"};

    private AuthleteApiFactory() {
    }

    public static AuthleteApi getInstance(AuthleteConfiguration configuration) {
        for (String className : sKnownImpls) {
            try {
                return AuthleteApiFactory.getInstance(configuration, className);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static AuthleteApi getInstance(AuthleteConfiguration configuration, String className) {
        AuthleteApi api;
        Constructor<?> constructor;
        Class<?> clazz;
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null.");
        }
        if (className == null) {
            throw new IllegalArgumentException("className is null.");
        }
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(className + " is not found.", e);
        }
        if (!AuthleteApi.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(className + " does not implement AuthleteApi interface.");
        }
        try {
            constructor = clazz.getConstructor(AuthleteConfiguration.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(className + " does not have a constructor which takes one AuthleteConfiguration parameter.", e);
        }
        try {
            api = (AuthleteApi)constructor.newInstance(configuration);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create an instance of " + className + ".", e);
        }
        return api;
    }
}

