/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.dto;

import com.authlete.common.dto.ApiResponse;
import com.authlete.common.dto.Client;
import com.authlete.common.dto.Scope;
import com.authlete.common.types.Display;
import com.authlete.common.types.Prompt;

public class AuthorizationResponse
extends ApiResponse {
    private static final long serialVersionUID = 2L;
    private static final String SUMMARY_FORMAT = "ticket=%s, action=%s, serviceNumber=%d, clientNumber=%d, clientId=%d, clientSecret=%s, clientType=%s, developer=%s, display=%s, maxAge=%d, scopes=%s, uiLocales=%s, claimsLocales-%s, claims=%s, acrEssential=%s, acrs=%s, subject=%s, loginHint=%s, lowestPrompt=%s";
    private Action action;
    private Client client;
    private Display display;
    private int maxAge;
    private Scope[] scopes;
    private String[] uiLocales;
    private String[] claimsLocales;
    private String[] claims;
    private boolean acrEssential;
    private String[] acrs;
    private String subject;
    private String loginHint;
    private Prompt lowestPrompt;
    private String responseContent;
    private String ticket;

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public Scope[] getScopes() {
        return this.scopes;
    }

    public void setScopes(Scope[] scopes) {
        this.scopes = scopes;
    }

    public String[] getUiLocales() {
        return this.uiLocales;
    }

    public void setUiLocales(String[] uiLocales) {
        this.uiLocales = uiLocales;
    }

    public String[] getClaimsLocales() {
        return this.claimsLocales;
    }

    public void setClaimsLocales(String[] claimsLocales) {
        this.claimsLocales = claimsLocales;
    }

    public String[] getClaims() {
        return this.claims;
    }

    public void setClaims(String[] claims) {
        this.claims = claims;
    }

    public boolean isAcrEssential() {
        return this.acrEssential;
    }

    public void setAcrEssential(boolean essential) {
        this.acrEssential = essential;
    }

    public String[] getAcrs() {
        return this.acrs;
    }

    public void setAcrs(String[] acrs) {
        this.acrs = acrs;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public Prompt getLowestPrompt() {
        return this.lowestPrompt;
    }

    public void setLowestPrompt(Prompt prompt) {
        this.lowestPrompt = prompt;
    }

    public String getResponseContent() {
        return this.responseContent;
    }

    public void setResponseContent(String content) {
        this.responseContent = content;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String summarize() {
        return String.format(SUMMARY_FORMAT, new Object[]{this.ticket, this.action, this.client != null ? this.client.getServiceNumber() : 0, this.client != null ? this.client.getNumber() : 0, this.client != null ? this.client.getClientId() : 0L, this.client != null ? this.client.getClientSecret() : null, this.client != null ? this.client.getClientType() : null, this.client != null ? this.client.getDeveloper() : null, this.display, this.maxAge, this.listScopeNames(this.scopes), this.join(this.uiLocales), this.join(this.claimsLocales), this.join(this.claims), this.acrEssential, this.join(this.acrs), this.subject, this.loginHint, this.lowestPrompt});
    }

    private String listScopeNames(Scope[] scopes) {
        if (scopes == null) {
            return null;
        }
        if (scopes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Scope scope : scopes) {
            sb.append(scope.getName());
            sb.append(" ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private String join(String[] strings) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string);
            sb.append(" ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static enum Action {
        INTERNAL_SERVER_ERROR,
        BAD_REQUEST,
        LOCATION,
        FORM,
        NO_INTERACTION,
        INTERACTION;

    }
}

