/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ApplicationType {
    WEB(1, "web"),
    NATIVE(2, "native");

    private static final ApplicationType[] mValues;
    private static final Helper mHelper;
    private final short mValue;
    private final String mString;

    private ApplicationType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ApplicationType getByValue(short value) {
        if (value < 1 || mValues.length < value) {
            return null;
        }
        return mValues[value - 1];
    }

    public static ApplicationType parse(String applicationType) {
        if (applicationType == null) {
            return null;
        }
        for (ApplicationType entry : ApplicationType.values()) {
            if (!entry.mString.equals(applicationType)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<ApplicationType> set) {
        return mHelper.toBits(set);
    }

    public static ApplicationType[] toArray(int bits) {
        return (ApplicationType[])mHelper.toArray(bits);
    }

    public static EnumSet<ApplicationType> toSet(int bits) {
        return mHelper.toSet(bits);
    }

    public static EnumSet<ApplicationType> toSet(ApplicationType[] array) {
        return mHelper.toSet(array);
    }

    static {
        mValues = ApplicationType.values();
        mHelper = new Helper(mValues);
    }

    private static class Helper
    extends EnumHelper<ApplicationType> {
        public Helper(ApplicationType[] values) {
            super(ApplicationType.class, (Enum[])values);
        }

        @Override
        protected short getValue(ApplicationType entry) {
            return entry.getValue();
        }

        protected ApplicationType[] newArray(int size) {
            return new ApplicationType[size];
        }
    }
}

