/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ClaimType {
    NORMAL(1, "normal"),
    AGGREGATED(2, "aggregated"),
    DISTRIBUTED(3, "distributed");

    private static final ClaimType[] mValues;
    private static final Helper mHelper;
    private final short mValue;
    private final String mString;

    private ClaimType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ClaimType getByValue(short value) {
        if (value < 1 || mValues.length < value) {
            return null;
        }
        return mValues[value - 1];
    }

    public static ClaimType parse(String claimType) {
        if (claimType == null) {
            return null;
        }
        for (ClaimType value : ClaimType.values()) {
            if (!value.mString.equals(claimType)) continue;
            return value;
        }
        return null;
    }

    public static int toBits(EnumSet<ClaimType> set) {
        return mHelper.toBits(set);
    }

    public static ClaimType[] toArray(int bits) {
        return (ClaimType[])mHelper.toArray(bits);
    }

    public static EnumSet<ClaimType> toSet(int bits) {
        return mHelper.toSet(bits);
    }

    public static EnumSet<ClaimType> toSet(ClaimType[] array) {
        return mHelper.toSet(array);
    }

    static {
        mValues = ClaimType.values();
        mHelper = new Helper(mValues);
    }

    private static class Helper
    extends EnumHelper<ClaimType> {
        public Helper(ClaimType[] values) {
            super(ClaimType.class, (Enum[])values);
        }

        @Override
        protected short getValue(ClaimType entry) {
            return entry.getValue();
        }

        protected ClaimType[] newArray(int size) {
            return new ClaimType[size];
        }
    }
}

