/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ClientAuthMethod {
    NONE(0, "none"),
    CLIENT_SECRET_BASIC(1, "client_secret_basic"),
    CLIENT_SECRET_POST(2, "client_secret_post"),
    CLIENT_SECRET_JWT(3, "client_secret_jwt"),
    PRIVATE_KEY_JWT(4, "private_key_jwt");

    private static final ClientAuthMethod[] mValues;
    private static final Helper mHelper;
    private final short mValue;
    private final String mString;

    private ClientAuthMethod(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ClientAuthMethod getByValue(short value) {
        if (value < 0 || mValues.length <= value) {
            return null;
        }
        return mValues[value];
    }

    public static ClientAuthMethod parse(String method) {
        if (method == null) {
            return null;
        }
        for (ClientAuthMethod entry : ClientAuthMethod.values()) {
            if (!entry.mString.equals(method)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<ClientAuthMethod> set) {
        return mHelper.toBits(set);
    }

    public static ClientAuthMethod[] toArray(int bits) {
        return (ClientAuthMethod[])mHelper.toArray(bits);
    }

    public static EnumSet<ClientAuthMethod> toSet(int bits) {
        return mHelper.toSet(bits);
    }

    public static EnumSet<ClientAuthMethod> toSet(ClientAuthMethod[] array) {
        return mHelper.toSet(array);
    }

    static {
        mValues = ClientAuthMethod.values();
        mHelper = new Helper(mValues);
    }

    private static class Helper
    extends EnumHelper<ClientAuthMethod> {
        public Helper(ClientAuthMethod[] values) {
            super(ClientAuthMethod.class, (Enum[])values);
        }

        @Override
        protected short getValue(ClientAuthMethod entry) {
            return entry.getValue();
        }

        protected ClientAuthMethod[] newArray(int size) {
            return new ClientAuthMethod[size];
        }
    }
}

