/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ClientType {
    PUBLIC(1, "public"),
    CONFIDENTIAL(2, "confidential");

    private static final ClientType[] mValues;
    private static final Helper mHelper;
    private final short mValue;
    private final String mString;

    private ClientType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ClientType getByValue(short value) {
        if (value < 1 || mValues.length < value) {
            return null;
        }
        return mValues[value - 1];
    }

    public static ClientType parse(String clientType) {
        if (clientType == null) {
            return null;
        }
        for (ClientType entry : ClientType.values()) {
            if (!entry.mString.equals(clientType)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<ClientType> set) {
        return mHelper.toBits(set);
    }

    public static ClientType[] toArray(int bits) {
        return (ClientType[])mHelper.toArray(bits);
    }

    public static EnumSet<ClientType> toSet(int bits) {
        return mHelper.toSet(bits);
    }

    public static EnumSet<ClientType> toSet(ClientType[] array) {
        return mHelper.toSet(array);
    }

    static {
        mValues = ClientType.values();
        mHelper = new Helper(mValues);
    }

    private static class Helper
    extends EnumHelper<ClientType> {
        public Helper(ClientType[] values) {
            super(ClientType.class, (Enum[])values);
        }

        @Override
        protected short getValue(ClientType entry) {
            return entry.getValue();
        }

        protected ClientType[] newArray(int size) {
            return new ClientType[size];
        }
    }
}

