/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum Display {
    PAGE(1, "page"),
    POPUP(2, "popup"),
    TOUCH(3, "touch"),
    WAP(4, "wap");

    private static final Display[] mValues;
    private static final Helper mHelper;
    private final short mValue;
    private final String mString;

    private Display(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static Display getByValue(short value) {
        if (value < 1 || mValues.length < value) {
            return null;
        }
        return mValues[value - 1];
    }

    public static Display parse(String display) {
        if (display == null) {
            return null;
        }
        for (Display value : Display.values()) {
            if (!value.mString.equals(display)) continue;
            return value;
        }
        return null;
    }

    public static int toBits(EnumSet<Display> set) {
        return mHelper.toBits(set);
    }

    public static Display[] toArray(int bits) {
        return (Display[])mHelper.toArray(bits);
    }

    public static EnumSet<Display> toSet(int bits) {
        return mHelper.toSet(bits);
    }

    public static EnumSet<Display> toSet(Display[] array) {
        return mHelper.toSet(array);
    }

    static {
        mValues = Display.values();
        mHelper = new Helper(mValues);
    }

    private static class Helper
    extends EnumHelper<Display> {
        public Helper(Display[] values) {
            super(Display.class, (Enum[])values);
        }

        @Override
        protected short getValue(Display entry) {
            return entry.getValue();
        }

        protected Display[] newArray(int size) {
            return new Display[size];
        }
    }
}

