/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum JWEEnc {
    A128CBC_HS256(1, "A128CBC-HS256"),
    A192CBC_HS384(2, "A192CBC-HS384"),
    A256CBC_HS512(3, "A256CBC-HS512"),
    A128GCM(4, "A128GCM"),
    A192GCM(5, "A192GCM"),
    A256GCM(6, "A256GCM");

    private static final JWEEnc[] mValues;
    private static final Helper mHelper;
    private final short mValue;
    private final String mString;

    private JWEEnc(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static JWEEnc getByValue(short value) {
        if (value < 1 || mValues.length < value) {
            return null;
        }
        return mValues[value - 1];
    }

    public static JWEEnc parse(String alg) {
        if (alg == null) {
            return null;
        }
        for (JWEEnc entry : JWEEnc.values()) {
            if (!entry.mString.equals(alg)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<JWEEnc> set) {
        return mHelper.toBits(set);
    }

    public static JWEEnc[] toArray(int bits) {
        return (JWEEnc[])mHelper.toArray(bits);
    }

    public static EnumSet<JWEEnc> toSet(int bits) {
        return mHelper.toSet(bits);
    }

    public static EnumSet<JWEEnc> toSet(JWEEnc[] array) {
        return mHelper.toSet(array);
    }

    static {
        mValues = JWEEnc.values();
        mHelper = new Helper(mValues);
    }

    private static class Helper
    extends EnumHelper<JWEEnc> {
        public Helper(JWEEnc[] values) {
            super(JWEEnc.class, (Enum[])values);
        }

        @Override
        protected short getValue(JWEEnc entry) {
            return entry.getValue();
        }

        protected JWEEnc[] newArray(int size) {
            return new JWEEnc[size];
        }
    }
}

