/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum Prompt {
    NONE(0, "none"),
    LOGIN(1, "login"),
    CONSENT(2, "consent"),
    SELECT_ACCOUNT(3, "select_account");

    private static final Prompt[] mValues;
    private static final Helper mHelper;
    private final short mValue;
    private final String mString;

    private Prompt(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static Prompt getByValue(short value) {
        if (value < 0 || mValues.length <= value) {
            return null;
        }
        return mValues[value];
    }

    public static Prompt parse(String prompt) {
        if (prompt == null) {
            return null;
        }
        for (Prompt value : Prompt.values()) {
            if (!value.mString.equals(prompt)) continue;
            return value;
        }
        return null;
    }

    public static int toBits(EnumSet<Prompt> set) {
        return mHelper.toBits(set);
    }

    public static Prompt[] toArray(int bits) {
        return (Prompt[])mHelper.toArray(bits);
    }

    public static EnumSet<Prompt> toSet(int bits) {
        return mHelper.toSet(bits);
    }

    public static EnumSet<Prompt> toSet(Prompt[] array) {
        return mHelper.toSet(array);
    }

    static {
        mValues = Prompt.values();
        mHelper = new Helper(mValues);
    }

    private static class Helper
    extends EnumHelper<Prompt> {
        public Helper(Prompt[] values) {
            super(Prompt.class, (Enum[])values);
        }

        @Override
        protected short getValue(Prompt entry) {
            return entry.getValue();
        }

        protected Prompt[] newArray(int size) {
            return new Prompt[size];
        }
    }
}

