/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ResponseType {
    NONE(0, "none", 0),
    CODE(1, "code", 1),
    TOKEN(2, "token", 2),
    ID_TOKEN(3, "id_token", 4),
    CODE_TOKEN(4, "code token", 3),
    CODE_ID_TOKEN(5, "code id_token", 5),
    ID_TOKEN_TOKEN(6, "id_token token", 6),
    CODE_ID_TOKEN_TOKEN(7, "code id_token token", 7);

    private static final int FLAG_CODE = 1;
    private static final int FLAG_TOKEN = 2;
    private static final int FLAG_ID_TOKEN = 4;
    private static final ResponseType[] mValues;
    private static final Helper mHelper;
    private final short mValue;
    private final String mString;
    private final int mFlags;

    private ResponseType(short value, String string2, int flags) {
        this.mValue = value;
        this.mString = string2;
        this.mFlags = flags;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public boolean containsCode() {
        return (this.mFlags & 1) != 0;
    }

    public boolean containsIdToken() {
        return (this.mFlags & 4) != 0;
    }

    public boolean containsToken() {
        return (this.mFlags & 2) != 0;
    }

    public boolean requiresImplicitFlow() {
        return (this.mFlags & 6) != 0;
    }

    public static ResponseType getByValue(short value) {
        if (value < 0 || mValues.length <= value) {
            return null;
        }
        return mValues[value];
    }

    public static ResponseType parse(String responseType) {
        if (responseType == null) {
            return null;
        }
        if (responseType.equals("none")) {
            return NONE;
        }
        String[] elements = responseType.split(" +");
        if (elements == null || elements.length == 0) {
            return null;
        }
        int flags = 0;
        for (String element : elements) {
            if (element == null || element.length() == 0) continue;
            if (element.equals("code")) {
                flags |= 1;
                continue;
            }
            if (element.equals("token")) {
                flags |= 2;
                continue;
            }
            if (element.equals("id_token")) {
                flags |= 4;
                continue;
            }
            return null;
        }
        switch (flags) {
            case 1: {
                return CODE;
            }
            case 2: {
                return TOKEN;
            }
            case 4: {
                return ID_TOKEN;
            }
            case 3: {
                return CODE_TOKEN;
            }
            case 5: {
                return CODE_ID_TOKEN;
            }
            case 6: {
                return ID_TOKEN_TOKEN;
            }
            case 7: {
                return CODE_ID_TOKEN_TOKEN;
            }
        }
        return null;
    }

    public static int toBits(EnumSet<ResponseType> set) {
        return mHelper.toBits(set);
    }

    public static ResponseType[] toArray(int bits) {
        return (ResponseType[])mHelper.toArray(bits);
    }

    public static EnumSet<ResponseType> toSet(int bits) {
        return mHelper.toSet(bits);
    }

    public static EnumSet<ResponseType> toSet(ResponseType[] array) {
        return mHelper.toSet(array);
    }

    static {
        mValues = ResponseType.values();
        mHelper = new Helper(mValues);
    }

    private static class Helper
    extends EnumHelper<ResponseType> {
        public Helper(ResponseType[] values) {
            super(ResponseType.class, (Enum[])values);
        }

        @Override
        protected short getValue(ResponseType entry) {
            return entry.getValue();
        }

        protected ResponseType[] newArray(int size) {
            return new ResponseType[size];
        }
    }
}

