/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public final class StandardClaims {
    public static final String SUB = "sub";
    public static final String NAME = "name";
    public static final String GIVEN_NAME = "given_name";
    public static final String FAMILY_NAME = "family_name";
    public static final String MIDDLE_NAME = "middle_name";
    public static final String NICKNAME = "nickname";
    public static final String PREFERRED_USERNAME = "preferred_username";
    public static final String PROFILE = "profile";
    public static final String PICTURE = "picture";
    public static final String WEBSITE = "website";
    public static final String EMAIL = "email";
    public static final String EMAIL_VERIFIED = "email_verified";
    public static final String GENDER = "gender";
    public static final String BIRTHDATE = "birthdate";
    public static final String ZONEINFO = "zoneinfo";
    public static final String LOCALE = "locale";
    public static final String PHONE_NUMBER = "phone_number";
    public static final String PHONE_NUMBER_VERIFIED = "phone_number_verified";
    public static final String ADDRESS = "address";
    public static final String UPDATED_AT = "updated_at";
    private static final SortedSet<String> sStandardClaims;

    private StandardClaims() {
    }

    public static boolean isStandardClaim(String claimName) {
        if (claimName == null) {
            return false;
        }
        return sStandardClaims.contains(claimName);
    }

    public static SortedSet<String> getStandardClaims() {
        return sStandardClaims;
    }

    static {
        TreeSet<String> set = new TreeSet<String>();
        set.add(SUB);
        set.add(NAME);
        set.add(GIVEN_NAME);
        set.add(FAMILY_NAME);
        set.add(MIDDLE_NAME);
        set.add(NICKNAME);
        set.add(PREFERRED_USERNAME);
        set.add(PROFILE);
        set.add(PICTURE);
        set.add(WEBSITE);
        set.add(EMAIL);
        set.add(EMAIL_VERIFIED);
        set.add(GENDER);
        set.add(BIRTHDATE);
        set.add(ZONEINFO);
        set.add(LOCALE);
        set.add(PHONE_NUMBER);
        set.add(PHONE_NUMBER_VERIFIED);
        set.add(ADDRESS);
        set.add(UPDATED_AT);
        sStandardClaims = Collections.unmodifiableSortedSet(set);
    }
}

