/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum SubjectType {
    PUBLIC(1, "public"),
    PAIRWISE(2, "pairwise");

    private static final SubjectType[] mValues;
    private static final Helper mHelper;
    private final short mValue;
    private final String mString;

    private SubjectType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static SubjectType getByValue(short value) {
        if (value < 1 || mValues.length < value) {
            return null;
        }
        return mValues[value - 1];
    }

    public static SubjectType parse(String subjectType) {
        if (subjectType == null) {
            return null;
        }
        for (SubjectType value : SubjectType.values()) {
            if (!value.mString.equals(subjectType)) continue;
            return value;
        }
        return null;
    }

    public static int toBits(EnumSet<SubjectType> set) {
        return mHelper.toBits(set);
    }

    public static SubjectType[] toArray(int bits) {
        return (SubjectType[])mHelper.toArray(bits);
    }

    public static EnumSet<SubjectType> toSet(int bits) {
        return mHelper.toSet(bits);
    }

    public static EnumSet<SubjectType> toSet(SubjectType[] array) {
        return mHelper.toSet(array);
    }

    static {
        mValues = SubjectType.values();
        mHelper = new Helper(mValues);
    }

    private static class Helper
    extends EnumHelper<SubjectType> {
        public Helper(SubjectType[] values) {
            super(SubjectType.class, (Enum[])values);
        }

        @Override
        protected short getValue(SubjectType entry) {
            return entry.getValue();
        }

        protected SubjectType[] newArray(int size) {
            return new SubjectType[size];
        }
    }
}

