/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.web;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class BasicCredentials {
    private static final Pattern CHALLENGE_PATTERN = Pattern.compile("^Basic *([^ ]+) *$", 2);
    private final String mUserId;
    private final String mPassword;

    public BasicCredentials(String userId, String password) {
        this.mUserId = userId;
        this.mPassword = password;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public static BasicCredentials parse(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = CHALLENGE_PATTERN.matcher(input);
        if (!matcher.matches()) {
            return new BasicCredentials(null, null);
        }
        String encoded = matcher.group(1);
        byte[] decoded = Base64.decodeBase64((String)encoded);
        String value = BasicCredentials.createString(decoded);
        String[] credentials = value.split(":", 2);
        String userId = null;
        String password = null;
        switch (credentials.length) {
            case 2: {
                password = credentials[1];
            }
            case 1: {
                userId = credentials[0];
            }
        }
        return new BasicCredentials(userId, password);
    }

    private static String createString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String format() {
        String credentials = String.format("%s:%s", this.mUserId == null ? "" : this.mUserId, this.mPassword == null ? "" : this.mPassword);
        byte[] credentialsBytes = BasicCredentials.getBytes(credentials);
        String encoded = Base64.encodeBase64String((byte[])credentialsBytes);
        return "Basic " + encoded;
    }

    private static byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return string.getBytes();
        }
    }
}

