/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ClaimType {
    NORMAL(1, "normal"),
    AGGREGATED(2, "aggregated"),
    DISTRIBUTED(3, "distributed");

    private static final ClaimType[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private ClaimType(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ClaimType getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static ClaimType parse(String claimType) {
        if (claimType == null) {
            return null;
        }
        for (ClaimType value : sValues) {
            if (!value.mString.equals(claimType)) continue;
            return value;
        }
        return null;
    }

    public static int toBits(EnumSet<ClaimType> set) {
        return sHelper.toBits(set);
    }

    public static ClaimType[] toArray(int bits) {
        return (ClaimType[])sHelper.toArray(bits);
    }

    public static EnumSet<ClaimType> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<ClaimType> toSet(ClaimType[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = ClaimType.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<ClaimType> {
        public Helper(ClaimType[] values) {
            super(ClaimType.class, (Enum[])values);
        }

        @Override
        protected short getValue(ClaimType entry) {
            return entry.getValue();
        }

        protected ClaimType[] newArray(int size) {
            return new ClaimType[size];
        }
    }
}

