/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.types;

import com.authlete.common.types.EnumHelper;
import java.util.EnumSet;

public enum ResponseMode {
    QUERY(1, "query"),
    FRAGMENT(2, "fragment"),
    FORM_POST(3, "form_post");

    private static final ResponseMode[] sValues;
    private static final Helper sHelper;
    private final short mValue;
    private final String mString;

    private ResponseMode(short value, String string2) {
        this.mValue = value;
        this.mString = string2;
    }

    public short getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mString;
    }

    public static ResponseMode getByValue(short value) {
        if (value < 1 || sValues.length < value) {
            return null;
        }
        return sValues[value - 1];
    }

    public static ResponseMode parse(String responseMode) {
        if (responseMode == null) {
            return null;
        }
        for (ResponseMode entry : sValues) {
            if (!entry.mString.equals(responseMode)) continue;
            return entry;
        }
        return null;
    }

    public static int toBits(EnumSet<ResponseMode> set) {
        return sHelper.toBits(set);
    }

    public static ResponseMode[] toArray(int bits) {
        return (ResponseMode[])sHelper.toArray(bits);
    }

    public static EnumSet<ResponseMode> toSet(int bits) {
        return sHelper.toSet(bits);
    }

    public static EnumSet<ResponseMode> toSet(ResponseMode[] array) {
        return sHelper.toSet(array);
    }

    static {
        sValues = ResponseMode.values();
        sHelper = new Helper(sValues);
    }

    private static class Helper
    extends EnumHelper<ResponseMode> {
        public Helper(ResponseMode[] values) {
            super(ResponseMode.class, (Enum[])values);
        }

        @Override
        protected short getValue(ResponseMode entry) {
            return entry.getValue();
        }

        protected ResponseMode[] newArray(int size) {
            return new ResponseMode[size];
        }
    }
}

